/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.util.ArrayList;
import mousekids.core.Inquiry;
import mousekids.core.InquiryUserController;
import mousekids.core.InquiryUserControllerListener;
import mousekids.core.SessionState;

public class InquiryController
implements InquiryUserController {
    protected Inquiry inquiry;
    protected ArrayList<InquiryUserControllerListener> inquiryUserControllerListener;
    protected SessionState sessionState;

    public InquiryController(Inquiry inq) {
        this.inquiry = inq;
        this.sessionState = new SessionState(this.inquiry.getSettings().getRowCount(), this.inquiry.getSettings().getColumnCount(), this.inquiry.getSettings().getPredictors());
        this.inquiryUserControllerListener = new ArrayList();
    }

    protected Inquiry getInquiry() {
        return this.inquiry;
    }

    @Override
    public boolean init() {
        int i = 0;
        while (i < this.inquiryUserControllerListener.size()) {
            this.inquiryUserControllerListener.get(i).initStarted();
            ++i;
        }
        this.sessionState.setPhase(1);
        i = 0;
        while (i < this.inquiryUserControllerListener.size()) {
            this.inquiryUserControllerListener.get(i).initEnded();
            ++i;
        }
        return true;
    }

    @Override
    public void setVL(String vL) {
        if (this.sessionState.getPhase() == 0) {
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).vL(vL);
                ++i;
            }
        }
    }

    @Override
    public void setVPN(String vPN) {
        if (this.sessionState.getPhase() == 0) {
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).vPN(vPN);
                ++i;
            }
        }
    }

    @Override
    public void selectPredictor(int index, String predictor) {
        if (this.sessionState.getPhase() == 1 && this.inquiry.getSettings().existsPredictor(predictor)) {
            this.sessionState.setSelectedPredictor(index, predictor);
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).predictorSelected(index, predictor);
                ++i;
            }
        }
    }

    @Override
    public void deselectPredictor(int index) {
        if (this.sessionState.getPhase() == 1 && this.sessionState.getSelectedPredictor(index) != null) {
            this.sessionState.setSelectedPredictor(index, null);
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).predictorDeselected(index);
                ++i;
            }
        }
    }

    @Override
    public boolean addValidityPoint(int pred, int n) {
        if (this.sessionState.getPhase() == 2 && pred > 0) {
            if (this.sessionState.isValidityPointSettable()) {
                this.sessionState.setNumberOfValidityPoints(pred, this.sessionState.getNumberOfValidityPoints(pred) + n);
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).validityPointAdded(pred, n);
                    ++i;
                }
                this.sessionState.setValidityPointSettable(false);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setDoor(int pred, int house, boolean open) {
        block41: {
            block40: {
                doSettingDoor = false;
                doCloseDoorAfterTimeout = false;
                doClosingClick = false;
                doAddRealTreasurePoint = false;
                if (!open || this.sessionState.getDoor(pred, house)) break block40;
                block1 : switch (this.sessionState.getPhase()) {
                    case 2: {
                        if (this.sessionState.isPredictionDoorChangeable()) {
                            if (pred == this.sessionState.getLearningPhaseCurrentPredictor()) {
                                this.sessionState.setPredictionDoorsChangeable(false);
                                this.sessionState.setHouseDoorsChangeable(true);
                                doSettingDoor = true;
                                break;
                            }
                            return;
                        }
                        if (this.sessionState.isHouseDoorsChangeable()) {
                            if (pred == 0) {
                                this.sessionState.setHouseDoorsChangeable(false);
                                m = this.inquiry.getLearningBoards().getPredictionMatrix(this.sessionState.getLearningPhaseCurrentBoard());
                                this.sessionState.setValidityPointSettable(m.getPrediction(pred, this.sessionState.getLearningPhaseCurrentPredictor() - 1) == m.getPrediction(this.sessionState.getLearningPhaseCurrentPredictor(), house));
                                doSettingDoor = true;
                                break;
                            }
                            return;
                        }
                        return;
                    }
                    case 6: {
                        if (pred != 0) ** GOTO lbl63
                        if (this.sessionState.isHouseDoorsChangeable()) {
                            this.sessionState.setHouseDoorsChangeable(false);
                            this.sessionState.setPredictionDoorsChangeable(false);
                            t = this.inquiry.getDecisionBoards().getPredictionMatrix(this.sessionState.getDecisionPhaseCurrentBoard()).getPrediction(pred, house);
                            if (this.sessionState.getDecisionPhaseCurrentBoard() > this.inquiry.getSettings().getNumberOfTrials() - 1) {
                                switch (InquiryController.$SWITCH_TABLE$mousekids$core$InquiryFactors$ImmediateFeedbackFactor()[this.inquiry.getFactors().getImmediateFeedback().ordinal()]) {
                                    case 1: {
                                        this.sessionState.setTreasurePointSettable(t);
                                        this.sessionState.setHighlightOption(true);
                                        break;
                                    }
                                    case 3: {
                                        this.sessionState.setTreasurePointSettable(true);
                                        this.sessionState.setHighlightOption(true);
                                        break;
                                    }
                                    case 2: {
                                        if (!this.sessionState.isFirstHouseOpened()) {
                                            this.sessionState.setTreasurePointSettable(t);
                                            this.sessionState.setFirstHouseOpened(true);
                                            this.sessionState.setHouseDoorsChangeable(t == false);
                                            this.sessionState.setHouseCounter(this.sessionState.getHouseCounter() + 1);
                                            this.sessionState.setHighlightOption(true);
                                        } else {
                                            t = false;
                                            this.sessionState.setHouseDoorsChangeable(true);
                                            this.sessionState.setHouseCounter(this.sessionState.getHouseCounter() + 1);
                                        }
                                        if (this.sessionState.getHouseCounter() != this.inquiry.getSettings().getColumnCount()) break;
                                        this.sessionState.setHouseDoorsChangeable(false);
                                    }
                                }
                                doAddRealTreasurePoint = t;
                            } else {
                                this.sessionState.setTreasurePointSettable(false);
                                doAddRealTreasurePoint = false;
                            }
                            doSettingDoor = true;
                            if (this.sessionState.isSecondDoor()) {
                                doClosingClick = true;
                                this.sessionState.setPredictionDoorsChangeable(true);
                                break;
                            }
                        }
                        break block41;
lbl63:
                        // 1 sources

                        if (!this.sessionState.isPredictionDoorChangeable()) break block41;
                        doSettingDoor = true;
                        switch (InquiryController.$SWITCH_TABLE$mousekids$core$InquiryFactors$VisibilityFactor()[this.inquiry.getFactors().getVisibility().ordinal()]) {
                            case 3: {
                                doCloseDoorAfterTimeout = true;
                                break block1;
                            }
                            case 5: {
                                if (this.sessionState.isSecondDoor()) {
                                    doClosingClick = true;
                                    break block1;
                                }
                                this.sessionState.setSecondDoor(true);
                                this.sessionState.setTempPred(pred);
                                this.sessionState.setTempHouse(house);
                            }
                        }
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block41;
            }
            if (!open && this.sessionState.getDoor(pred, house)) {
                if (pred == 0) {
                    if (this.sessionState.isHouseDoorsChangeable()) {
                        doSettingDoor = true;
                    }
                } else if (this.sessionState.isPredictionDoorChangeable()) {
                    doSettingDoor = true;
                }
            }
        }
        if (doSettingDoor) {
            this.sessionState.setDoor(pred, house, open);
            i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).doorSet(pred, house, open);
                ++i;
            }
        }
        if (doCloseDoorAfterTimeout) {
            this.sessionState.setExecutingClosing(true);
            try {
                Thread.sleep(this.inquiry.getSettings().getClosingTimeout());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.sessionState.setExecutingClosing(false);
            this.setDoor(pred, house, false);
        }
        if (doClosingClick) {
            this.setDoor(this.sessionState.getTempPred(), this.sessionState.getTempHouse(), false);
            this.sessionState.setTempPred(pred);
            this.sessionState.setTempHouse(house);
            if (pred == 0) {
                this.sessionState.setPredictionDoorsChangeable(false);
            }
        }
        if (doAddRealTreasurePoint) {
            this.addRealTreasurePoint(1);
        }
    }

    @Override
    public void selectDoor(int pred, int house) {
        boolean doSelectDoor = false;
        boolean doAddTreasurePoint = false;
        block0 : switch (this.sessionState.getPhase()) {
            case 6: {
                if (this.sessionState.getDecisionPhaseCurrentBoard() > this.inquiry.getSettings().getNumberOfTrials() - 1) {
                    switch (this.inquiry.getFactors().getImmediateFeedback()) {
                        case No: {
                            if (!this.sessionState.isHouseDoorsSelectable()) break block0;
                            if (pred == 0) {
                                this.sessionState.setPredictionDoorsChangeable(false);
                                this.sessionState.setHouseDoorsSelectable(false);
                                if (this.inquiry.getDecisionBoards().getPredictionMatrix(this.sessionState.getDecisionPhaseCurrentBoard()).getPrediction(pred, house)) {
                                    doAddTreasurePoint = true;
                                }
                                doSelectDoor = true;
                                break block0;
                            }
                            return;
                        }
                    }
                    break;
                }
                return;
            }
        }
        if (doSelectDoor) {
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).doorSelected(pred, house);
                ++i;
            }
        }
        if (doAddTreasurePoint) {
            this.sessionState.setTreasurePointSettable(true);
            this.addVisibleTreasurePoint(1);
            this.sessionState.setTreasurePointSettable(false);
        }
    }

    @Override
    public void addVisibleTreasurePoint(int n) {
        boolean doAddTreasurePoint = false;
        if (this.sessionState.treasurePointSettable) {
            switch (this.sessionState.getPhase()) {
                case 6: {
                    this.sessionState.setNumberOfVisibleTreasurePoints(this.sessionState.getNumberOfVisibleTreasurePoints() + n);
                    this.sessionState.setTreasurePointSettable(false);
                    doAddTreasurePoint = true;
                }
            }
            switch (this.inquiry.getFactors().getImmediateFeedback()) {
                case Complete: {
                    this.sessionState.setHouseDoorsChangeable(true);
                }
            }
        }
        if (doAddTreasurePoint) {
            int i = 0;
            while (i < this.inquiryUserControllerListener.size()) {
                this.inquiryUserControllerListener.get(i).visibileTreasurePointAdded(n);
                ++i;
            }
        }
    }

    private void addRealTreasurePoint(int n) {
        this.sessionState.setNumberOfRealTreasurePoints(this.sessionState.getNumberOfRealTreasurePoints() + n);
        int i = 0;
        while (i < this.inquiryUserControllerListener.size()) {
            this.inquiryUserControllerListener.get(i).realTreasurePointAdded(n);
            ++i;
        }
    }

    @Override
    public boolean next() {
        if (!this.sessionState.isNextable()) {
            return false;
        }
        switch (this.sessionState.getPhase()) {
            case 0: {
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).initEnded();
                    ++i;
                }
                this.sessionState.setPhase(1);
                i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).goneToSelectionPhase();
                    ++i;
                }
                return true;
            }
            case 1: {
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).selectionPhaseEnded();
                    ++i;
                }
                if (this.inquiry.getSettings().getNumberOfLearningPhases() == 0) {
                    this.sessionState.setPhase(4);
                    this.sessionState.setDecisionPhaseCurrentBoard(0);
                    this.initManipulationCheckBoard();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToManipulationCheckPhase();
                        ++i;
                    }
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToManipulationCheckBoard();
                        ++i;
                    }
                } else {
                    this.sessionState.setPhase(2);
                    this.sessionState.setLearningPhaseCurrentPhase(1);
                    this.sessionState.setLearningPhaseCurrentBoard(0);
                    this.sessionState.setLearningPhaseCurrentPredictor(1);
                    this.initLearningBoard();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToLearningPhase(this.sessionState.getLearningPhaseCurrentPhase());
                        ++i;
                    }
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToLearningBoard(this.sessionState.getLearningPhaseCurrentBoard(), this.sessionState.getLearningPhaseCurrentPredictor());
                        ++i;
                    }
                }
                return true;
            }
            case 2: {
                int newLearnBoard = (this.sessionState.getLearningPhaseCurrentBoard() + 1) % this.inquiry.getSettings().getNumberOfLearningBoards();
                this.sessionState.setLearningPhaseCurrentBoard(newLearnBoard);
                if (newLearnBoard == 0) {
                    int newPred = (this.sessionState.getLearningPhaseCurrentPredictor() - 1 + 1) % this.inquiry.getSettings().getRowCount() + 1;
                    this.sessionState.setLearningPhaseCurrentPredictor(newPred);
                    if (newPred == 1) {
                        int i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).learningPhaseEnded();
                            ++i;
                        }
                        this.sessionState.setPhase(3);
                        this.initAfterLearningBoard();
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToAfterLearningPhase();
                            ++i;
                        }
                        return true;
                    }
                }
                this.initLearningBoard();
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).goneToLearningBoard(this.sessionState.getLearningPhaseCurrentBoard(), this.sessionState.getLearningPhaseCurrentPredictor());
                    ++i;
                }
                return true;
            }
            case 3: {
                switch (this.sessionState.getRepeatingLearningPhaseChosen()) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        int i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).afterLearningPhaseEnded();
                            ++i;
                        }
                        this.sessionState.resetValidityPoints();
                        this.sessionState.setPhase(2);
                        this.sessionState.setLearningPhaseCurrentPhase(this.sessionState.getLearningPhaseCurrentPhase() + 1);
                        this.sessionState.setLearningPhaseCurrentBoard(0);
                        this.sessionState.setLearningPhaseCurrentPredictor(1);
                        this.initLearningBoard();
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToLearningPhase(this.sessionState.getLearningPhaseCurrentPhase());
                            ++i;
                        }
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToLearningBoard(this.sessionState.getLearningPhaseCurrentBoard(), this.sessionState.getLearningPhaseCurrentPredictor());
                            ++i;
                        }
                        return true;
                    }
                    case 2: {
                        int i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).afterLearningPhaseEnded();
                            ++i;
                        }
                        this.sessionState.setPhase(4);
                        this.sessionState.setDecisionPhaseCurrentBoard(0);
                        this.initManipulationCheckBoard();
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToManipulationCheckPhase();
                            ++i;
                        }
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToManipulationCheckBoard();
                            ++i;
                        }
                        return true;
                    }
                }
            }
            case 4: {
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).manipulationCheckPhaseEnded();
                    ++i;
                }
                if (this.inquiry.getSettings().getQuestionnares() != null) {
                    this.sessionState.setPhase(5);
                    this.sessionState.setDecisionPhaseCurrentBoard(0);
                    this.initQuestionnareBoard();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToQuestionnarePhase();
                        ++i;
                    }
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToQuestionnareBoard(this.sessionState.getDecisionPhaseCurrentBoard());
                        ++i;
                    }
                } else if (!this.sessionState.isDecisionPhaseOver()) {
                    this.sessionState.setPhase(6);
                    this.sessionState.setDecisionPhaseCurrentBoard(0);
                    this.initDecisionBoard();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToDecisionPhase();
                        ++i;
                    }
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToDecisionBoard(this.sessionState.getDecisionPhaseCurrentBoard());
                        ++i;
                    }
                } else {
                    this.sessionState.setPhase(7);
                    this.initFeedbackPhase();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToFeedbackPhase(this.sessionState.getNumberOfRealTreasurePoints());
                        ++i;
                    }
                }
                return true;
            }
            case 5: {
                int newQuesBoard = (this.sessionState.getDecisionPhaseCurrentBoard() + 1) % this.inquiry.getSettings().getQuestionnares().length;
                this.sessionState.setDecisionPhaseCurrentBoard(newQuesBoard);
                if (newQuesBoard == 0) {
                    int i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).questionnarePhaseEnded();
                        ++i;
                    }
                    if (!this.sessionState.isDecisionPhaseOver()) {
                        this.sessionState.setPhase(6);
                        this.sessionState.setDecisionPhaseCurrentBoard(0);
                        this.initDecisionBoard();
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToDecisionPhase();
                            ++i;
                        }
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToDecisionBoard(this.sessionState.getDecisionPhaseCurrentBoard());
                            ++i;
                        }
                    } else {
                        this.sessionState.setPhase(7);
                        this.initFeedbackPhase();
                        i = 0;
                        while (i < this.inquiryUserControllerListener.size()) {
                            this.inquiryUserControllerListener.get(i).goneToFeedbackPhase(this.sessionState.getNumberOfRealTreasurePoints());
                            ++i;
                        }
                    }
                    return true;
                }
                this.initQuestionnareBoard();
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).goneToQuestionnareBoard(this.sessionState.getDecisionPhaseCurrentBoard());
                    ++i;
                }
                return true;
            }
            case 6: {
                int newDecisBoard = (this.sessionState.getDecisionPhaseCurrentBoard() + 1) % this.inquiry.getSettings().getNumberOfDecisionBoards();
                this.sessionState.setDecisionPhaseCurrentBoard(newDecisBoard);
                if (newDecisBoard == 0) {
                    if (!this.sessionState.isBreakAfterLastDecision()) {
                        newDecisBoard = (this.sessionState.getDecisionPhaseCurrentBoard() - 1) % this.inquiry.getSettings().getNumberOfDecisionBoards();
                        this.sessionState.setDecisionPhaseCurrentBoard(newDecisBoard);
                        this.sessionState.setBreakAfterLastDecision(true);
                        this.sessionState.setShowBreakAfterLastDecisionBoard(true);
                        this.initAfterLearningBoard();
                        return true;
                    }
                    int i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).decisionPhaseEnded();
                        ++i;
                    }
                    this.sessionState.setDecisionPhaseOver(true);
                    this.sessionState.setPhase(4);
                    this.initManipulationCheckBoard();
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToManipulationCheckPhase();
                        ++i;
                    }
                    i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToManipulationCheckBoard();
                        ++i;
                    }
                    return true;
                }
                if (this.sessionState.getDecisionPhaseCurrentBoard() == this.inquiry.getSettings().getNumberOfTrials() && !this.sessionState.isBreakAfterTrials) {
                    newDecisBoard = (this.sessionState.getDecisionPhaseCurrentBoard() - 1) % this.inquiry.getSettings().getNumberOfDecisionBoards();
                    this.sessionState.setDecisionPhaseCurrentBoard(newDecisBoard);
                    this.sessionState.setBreakAfterTrials(true);
                    this.sessionState.setShowBreakAfterTrialsBoard(true);
                    this.initAfterLearningBoard();
                    return true;
                }
                if (this.inquiry.getSettings().getBreakAfterDB().size() > 0 && this.sessionState.getDecisionPhaseCurrentBoard() == this.inquiry.getSettings().getBreakAfterDB().get(0).intValue()) {
                    this.inquiry.getSettings().getBreakAfterDB().remove(0);
                    newDecisBoard = (this.sessionState.getDecisionPhaseCurrentBoard() - 1) % this.inquiry.getSettings().getNumberOfDecisionBoards();
                    this.sessionState.setDecisionPhaseCurrentBoard(newDecisBoard);
                    this.sessionState.setBreak(true);
                    this.sessionState.setShowBreak(true);
                    this.initAfterLearningBoard();
                    int i = 0;
                    while (i < this.inquiryUserControllerListener.size()) {
                        this.inquiryUserControllerListener.get(i).goneToBreakBoard();
                        ++i;
                    }
                    return true;
                }
                this.initDecisionBoard();
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).goneToDecisionBoard(this.sessionState.getDecisionPhaseCurrentBoard());
                    ++i;
                }
                return true;
            }
            case 7: {
                this.sessionState.setPhase(-1);
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).feedbackPhaseEnded();
                    ++i;
                }
                return true;
            }
            case -1: {
                int i = 0;
                while (i < this.inquiryUserControllerListener.size()) {
                    this.inquiryUserControllerListener.get(i).terminated();
                    ++i;
                }
                return false;
            }
        }
        return false;
    }

    private void initAfterLearningBoard() {
        this.sessionState.setAllDoors(false);
        this.sessionState.setPredictionDoorsChangeable(false);
        this.sessionState.setHouseDoorsChangeable(false);
        this.sessionState.setHouseDoorsSelectable(false);
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasurePointVisible(false);
        this.sessionState.setAllOutcomeTrivial(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
    }

    private void initLearningBoard() {
        this.sessionState.createDoorMatrix(this.inquiry.getSettings().getRowCount() + 1, 1);
        this.sessionState.setAllDoors(false);
        this.sessionState.setPredictionDoorsChangeable(true);
        this.sessionState.setHouseDoorsChangeable(false);
        this.sessionState.setHouseDoorsSelectable(false);
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasurePointVisible(false);
        this.sessionState.setAllOutcomeTrivial(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
    }

    private void initManipulationCheckBoard() {
        this.sessionState.createDoorMatrix(this.inquiry.getSettings().getRowCount() + 1, this.inquiry.getSettings().getColumnCount());
        this.sessionState.setAllDoors(false);
        this.sessionState.setPredictionDoorsChangeable(false);
        this.sessionState.setHouseDoorsChangeable(false);
        this.sessionState.setHouseDoorsSelectable(false);
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasurePointVisible(false);
        this.sessionState.setAllOutcomeTrivial(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setAllOutcomeTrivial(true);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
    }

    private void initQuestionnareBoard() {
        this.sessionState.createDoorMatrix(this.inquiry.getSettings().getRowCount() + 1, this.inquiry.getSettings().getColumnCount());
        this.sessionState.setAllDoors(false);
        this.sessionState.setPredictionDoorsChangeable(false);
        this.sessionState.setHouseDoorsChangeable(false);
        this.sessionState.setHouseDoorsSelectable(false);
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasurePointVisible(false);
        this.sessionState.setAllOutcomeTrivial(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setAllOutcomeTrivial(true);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
    }

    private void initDecisionBoard() {
        this.sessionState.createDoorMatrix(this.inquiry.getSettings().getRowCount() + 1, this.inquiry.getSettings().getColumnCount());
        this.sessionState.setHouseDoors(false);
        switch (this.inquiry.getFactors().getVisibility()) {
            case Open: {
                this.sessionState.setPredictionDoors(true);
                this.sessionState.setPredictionDoorsChangeable(false);
                break;
            }
            case Closed: {
                this.sessionState.setPredictionDoors(false);
                this.sessionState.setPredictionDoorsChangeable(true);
                break;
            }
            case Closing: {
                this.sessionState.setPredictionDoors(false);
                this.sessionState.setPredictionDoorsChangeable(true);
                break;
            }
            case ClosingClick: {
                this.sessionState.setPredictionDoors(false);
                this.sessionState.setPredictionDoorsChangeable(true);
            }
        }
        switch (this.inquiry.getFactors().getImmediateFeedback()) {
            case Yes: {
                this.sessionState.setHouseDoorsChangeable(true);
                this.sessionState.setHouseDoorsSelectable(false);
                this.sessionState.setTreasurePointVisible(true);
                this.sessionState.setHouseOutcomeTrivial(false);
                this.sessionState.setPredictionOutcomeTrivial(false);
                break;
            }
            case No: {
                this.sessionState.setHouseDoorsChangeable(true);
                this.sessionState.setTreasurePointVisible(true);
                this.sessionState.setHouseDoorsSelectable(false);
                if (this.sessionState.getDecisionPhaseCurrentBoard() > this.inquiry.getSettings().getNumberOfTrials() - 1) {
                    this.sessionState.setHouseOutcomeTrivial(true);
                } else {
                    this.sessionState.setHouseOutcomeTrivial(false);
                }
                this.sessionState.setPredictionOutcomeTrivial(false);
                break;
            }
            case Complete: {
                this.sessionState.setHouseDoorsChangeable(true);
                this.sessionState.setHouseDoorsSelectable(false);
                this.sessionState.setTreasurePointVisible(true);
                this.sessionState.setHouseOutcomeTrivial(false);
                this.sessionState.setPredictionOutcomeTrivial(false);
                this.sessionState.setFirstHouseOpened(false);
                this.sessionState.setHouseCounter(0);
            }
        }
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
        this.sessionState.setHighlightOption(false);
    }

    private void initFeedbackPhase() {
        this.sessionState.setAllDoors(false);
        this.sessionState.setPredictionDoorsChangeable(false);
        this.sessionState.setHouseDoorsChangeable(false);
        this.sessionState.setHouseDoorsSelectable(false);
        this.sessionState.setValidityPointSettable(false);
        this.sessionState.setTreasurePointSettable(false);
        this.sessionState.setTreasurePointVisible(false);
        this.sessionState.setAllOutcomeTrivial(false);
        this.sessionState.setTreasureFound(false);
        this.sessionState.setRepeatingLearningPhaseChosen(0);
    }

    public void addUserControllerListener(InquiryUserControllerListener inqUserCtrlListener) {
        this.inquiryUserControllerListener.add(inqUserCtrlListener);
    }

    public void removeUserControllerListener(InquiryUserControllerListener inqUserCtrlListener) {
        this.inquiryUserControllerListener.remove(inqUserCtrlListener);
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public void repeatLearningPhase(boolean yes) {
        switch (this.sessionState.getPhase()) {
            case 3: {
                if (yes) {
                    this.sessionState.setRepeatingLearningPhaseChosen(1);
                    break;
                }
                this.sessionState.setRepeatingLearningPhaseChosen(2);
            }
        }
    }
}

