/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import mousekids.core.Boards;
import mousekids.core.Inquiry;
import mousekids.core.InquiryFactors;
import mousekids.core.InquiryFile;
import mousekids.core.InquiryFileSection;
import mousekids.core.InquiryProcess;
import mousekids.core.InquirySettings;
import mousekids.core.MousekidsProtocolException;
import mousekids.core.PredictionMatrix;

public class InquiryFileIO {
    public static final String newline = System.getProperty("line.separator");

    private InquiryFileIO() {
    }

    public static InquiryFile readInquiryFile(BufferedReader reader) throws MousekidsProtocolException, IOException {
        InquiryFile inqFile;
        InquiryFileSection sec;
        block14: {
            String line;
            int lineNumber;
            int protocolVersion;
            block13: {
                protocolVersion = -1;
                lineNumber = 0;
                sec = null;
                inqFile = null;
                line = reader.readLine();
                if (line != null) {
                    ++lineNumber;
                    try {
                        protocolVersion = Integer.parseInt(line);
                        break block13;
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("invalid protocol version number \"" + line + "\"");
                    }
                }
                return null;
            }
            try {
                if (protocolVersion <= 0) {
                    throw new MousekidsProtocolException("unset protocol version number");
                }
                inqFile = new InquiryFile(protocolVersion);
                if (protocolVersion == 1) {
                    while ((line = reader.readLine()) != null) {
                        String s;
                        ++lineNumber;
                        ArrayList<String> sbls = InquiryFileIO.splitArguments(line, protocolVersion);
                        if (sbls.size() > 0 && (s = sbls.get(0)).charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                            String secName = s.substring(1, s.length() - 1);
                            if (sbls.size() > 1) {
                                throw new MousekidsProtocolException("declaration of section \"" + secName + "\"with additional characters");
                            }
                            if (sec != null) {
                                inqFile.add(sec);
                            }
                            sec = new InquiryFileSection(secName);
                            continue;
                        }
                        if (sec == null) continue;
                        sec.addLine(sbls);
                    }
                    break block14;
                }
                throw new MousekidsProtocolException("unkown protocol version \"" + line + "\"");
            }
            catch (MousekidsProtocolException e) {
                throw new MousekidsProtocolException(String.valueOf(e.getMessage()) + newline + "when reading in line " + lineNumber);
            }
        }
        if (sec != null) {
            inqFile.add(sec);
            sec = null;
        }
        return inqFile;
    }

    protected static ArrayList<String> splitArguments(String line, int protocolVersion) throws MousekidsProtocolException {
        ArrayList<String> sbls = new ArrayList<String>();
        if (protocolVersion == 1) {
            StringBuilder sb = new StringBuilder();
            int len = line.length();
            boolean inString = false;
            boolean inSpace = true;
            boolean lastElementAdded = true;
            int i = 0;
            while (i < len) {
                char c = line.charAt(i);
                if (c < ' ' || c > '\u007f') {
                    throw new MousekidsProtocolException("character '" + c + "' (0x" + Integer.toHexString(c) + ") out of range [0x20, 0x7f]");
                }
                if (inString) {
                    if (c == '\"') {
                        inString = false;
                    } else {
                        sb.append(c);
                    }
                } else if (c == ' ') {
                    if (!inSpace) {
                        sbls.add(sb.toString());
                        sb = new StringBuilder();
                        lastElementAdded = true;
                        inSpace = true;
                    }
                } else if (c == '\"') {
                    inString = true;
                    inSpace = false;
                    lastElementAdded = false;
                } else {
                    if (c == '#') {
                        if (inSpace || i <= 0) break;
                        sbls.add(sb.toString());
                        lastElementAdded = true;
                        break;
                    }
                    sb.append(c);
                    inSpace = false;
                    lastElementAdded = false;
                }
                ++i;
            }
            if (!lastElementAdded) {
                sbls.add(sb.toString());
                lastElementAdded = false;
            }
        } else {
            throw new MousekidsProtocolException("don't know how to read arguments (protocol version " + protocolVersion + ")");
        }
        return sbls;
    }

    public static void writeInquiryFile(InquiryFile inqFile, BufferedWriter writer, int protocolVersion) throws IOException, MousekidsProtocolException {
        int nos = inqFile.getNumberOfSections();
        writer.write(Integer.toString(protocolVersion));
        writer.newLine();
        writer.newLine();
        int i = 0;
        while (i < nos) {
            InquiryFileSection ifs = inqFile.getSection(i);
            if (ifs != null) {
                writer.write(String.valueOf('[') + InquiryFileIO.escapeArgument(ifs.getName(), protocolVersion) + ']');
                writer.newLine();
                writer.newLine();
                int nol = ifs.getNumberOfLines();
                int j = 0;
                while (j < nol) {
                    ArrayList<String> line = ifs.getLine(j);
                    int noa = line.size();
                    if (noa > 0) {
                        writer.write(InquiryFileIO.escapeArgument(line.get(0), protocolVersion));
                    }
                    int k = 1;
                    while (k < noa) {
                        writer.write(32);
                        writer.write(InquiryFileIO.escapeArgument(line.get(k), protocolVersion));
                        ++k;
                    }
                    writer.newLine();
                    ++j;
                }
            }
            ++i;
        }
        writer.flush();
    }

    protected static String escapeArgument(String arg, int protocolVersion) throws MousekidsProtocolException {
        if (protocolVersion == 1) {
            int len = arg.length();
            boolean toEscape = false;
            StringBuilder sb = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = arg.charAt(i);
                if (c < ' ' || c > '\u007f') {
                    throw new MousekidsProtocolException("character '" + c + "' (0x" + Integer.toHexString(c) + ") out of range [0x20, 0x7f]");
                }
                if (c == '\"') {
                    throw new MousekidsProtocolException("cannot escape character '" + c + "' (0x" + Integer.toHexString(c) + ") (protocol version " + protocolVersion + ")");
                }
                if (c == ' ') {
                    toEscape = true;
                }
                ++i;
            }
            if (toEscape) {
                sb.append('\"').append(arg).append('\"');
            } else {
                sb.append(arg);
            }
            return sb.toString();
        }
        throw new MousekidsProtocolException("don't know how to write arguments (protocol version " + protocolVersion + ")");
    }

    public static Inquiry createInquiry(InquiryFile inqFile) throws MousekidsProtocolException {
        int nos = inqFile.getNumberOfSections();
        InquirySettings settings = null;
        Boards learningBoards = null;
        Boards decisionBoards = null;
        InquiryFactors factors = null;
        InquiryProcess process = null;
        int i = 0;
        while (i < nos) {
            InquiryFileSection inqFileSection = inqFile.getSection(i);
            String secName = inqFileSection.getName();
            if (secName.equals("SETTINGS")) {
                settings = InquiryFileIO.extractInquirySettings(inqFileSection);
            } else if (secName.equals("LEARNINGBOARDS")) {
                learningBoards = InquiryFileIO.extractBoards(inqFileSection);
            } else if (secName.equals("DECISIONBOARDS")) {
                decisionBoards = InquiryFileIO.extractBoards(inqFileSection);
            } else if (secName.equals("FACTORS")) {
                factors = InquiryFileIO.extractInquiryFactors(inqFileSection);
            } else if (secName.equals("PROCESS")) {
                process = InquiryFileIO.extractInquiryProcess(inqFileSection);
            } else {
                throw new MousekidsProtocolException("unkown section: " + secName);
            }
            ++i;
        }
        return new Inquiry(settings, learningBoards, decisionBoards, factors, process);
    }

    private static ArrayList<ArrayList<String>> extract2DArray(InquiryFileSection inqFileSection, int startIndex) throws MousekidsProtocolException {
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        int nol = inqFileSection.getNumberOfLines();
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = inqFileSection.getLine(startIndex + i);
            if (arg.size() <= 0) break;
            list.add(arg);
            ++i;
        }
        return list;
    }

    private static ArrayList<String> extract1DArray(InquiryFileSection inqFileSection, int startIndex) throws MousekidsProtocolException {
        ArrayList<ArrayList<String>> s = InquiryFileIO.extract2DArray(inqFileSection, startIndex);
        ArrayList<String> res = new ArrayList<String>();
        int len = s.size();
        int i = 0;
        while (i < len) {
            if (s.get(i).size() > 1) {
                throw new MousekidsProtocolException("only one value in line expected");
            }
            res.add(s.get(i).get(0));
            ++i;
        }
        return res;
    }

    protected static ArrayList<PredictionMatrix> extractPredictionMatrices(InquiryFileSection inqFileSection) throws MousekidsProtocolException {
        int nol = inqFileSection.getNumberOfLines();
        ArrayList<PredictionMatrix> predMatrixLs = new ArrayList<PredictionMatrix>();
        ArrayList<Boolean> matrixRow = new ArrayList<Boolean>();
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = inqFileSection.getLine(i);
            if (arg.size() > 0) {
                ArrayList<ArrayList<String>> rawBoard = InquiryFileIO.extract2DArray(inqFileSection, i);
                int rows = rawBoard.size();
                i += rows;
                ArrayList<ArrayList<Boolean>> matrix = new ArrayList<ArrayList<Boolean>>(rows);
                int r = 0;
                while (r < rows) {
                    ArrayList<String> rawBoardRow = rawBoard.get(r);
                    int cols = rawBoardRow.size();
                    matrixRow = new ArrayList(cols);
                    int c = 0;
                    while (c < cols) {
                        String rawBoardEntry = rawBoardRow.get(c);
                        if (rawBoardEntry.equals("t")) {
                            matrixRow.add(true);
                        } else if (rawBoardEntry.equals("s")) {
                            matrixRow.add(false);
                        } else {
                            throw new MousekidsProtocolException("Illegal board (" + (predMatrixLs.size() + 1) + ") matrix entry: " + rawBoardEntry);
                        }
                        ++c;
                    }
                    matrix.add(matrixRow);
                    ++r;
                }
                predMatrixLs.add(new PredictionMatrix(matrix));
            }
            ++i;
        }
        return predMatrixLs;
    }

    protected static Boards extractBoards(InquiryFileSection inqFileSection) throws MousekidsProtocolException {
        ArrayList<PredictionMatrix> temp = InquiryFileIO.extractPredictionMatrices(inqFileSection);
        return new Boards(temp.toArray(new PredictionMatrix[temp.size()]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static InquiryFactors extractInquiryFactors(InquiryFileSection inqFileSection) throws MousekidsProtocolException {
        InquiryFactors inqFac = new InquiryFactors();
        int nol = inqFileSection.getNumberOfLines();
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = inqFileSection.getLine(i);
            int argSize = arg.size();
            if (argSize > 0) {
                String val;
                String attr = arg.get(0);
                if (attr.equals("FriendIsBestFactor")) {
                    if (argSize <= 1) throw new MousekidsProtocolException("missing FriendIsBestFactor value");
                    val = arg.get(1);
                    if (val.equals("yes")) {
                        inqFac.setFriendIsBest(InquiryFactors.YesNoFactor.Yes);
                    } else if (val.equals("no")) {
                        inqFac.setFriendIsBest(InquiryFactors.YesNoFactor.No);
                    } else {
                        if (!val.equals("random")) throw new MousekidsProtocolException("unkown value for FriendIsBestFactor: " + val);
                        inqFac.setFriendIsBest(InquiryFactors.YesNoFactor.Random);
                    }
                    if (argSize > 2) {
                        throw new MousekidsProtocolException("too many values for FriendIsBestFactor: " + (argSize - 1));
                    }
                } else if (attr.equals("ImmediateFeedbackFactor")) {
                    if (argSize <= 1) throw new MousekidsProtocolException("missing ImmediateFeedbackFactor value");
                    val = arg.get(1);
                    if (val.equals("yes")) {
                        inqFac.setImmediateFeedback(InquiryFactors.ImmediateFeedbackFactor.Yes);
                    } else if (val.equals("no")) {
                        inqFac.setImmediateFeedback(InquiryFactors.ImmediateFeedbackFactor.No);
                    } else {
                        if (!val.equals("complete")) throw new MousekidsProtocolException("unkown value for ImmediateFeedbackFactor: " + val);
                        inqFac.setImmediateFeedback(InquiryFactors.ImmediateFeedbackFactor.Complete);
                    }
                    if (argSize > 2) {
                        throw new MousekidsProtocolException("too many values for ImmediateFeedbackFactor: " + (argSize - 1));
                    }
                } else if (attr.equals("VisibilityFactor")) {
                    if (argSize <= 1) throw new MousekidsProtocolException("missing VisibilityFactor value");
                    val = arg.get(1);
                    if (val.equals("open")) {
                        inqFac.setVisibility(InquiryFactors.VisibilityFactor.Open);
                    } else if (val.equals("closed")) {
                        inqFac.setVisibility(InquiryFactors.VisibilityFactor.Closed);
                    } else if (val.equals("closing")) {
                        inqFac.setVisibility(InquiryFactors.VisibilityFactor.Closing);
                    } else if (val.equals("closingClick")) {
                        inqFac.setVisibility(InquiryFactors.VisibilityFactor.ClosingClick);
                    } else {
                        if (!val.equals("random")) throw new MousekidsProtocolException("unkown value for VisibilityFactor: " + val);
                        inqFac.setVisibility(InquiryFactors.VisibilityFactor.Random);
                    }
                    if (argSize > 2) {
                        throw new MousekidsProtocolException("too many values for VisibilityFactor: " + (argSize - 1));
                    }
                } else if (!attr.equals("DecisionBoardsOrder") && attr.equals("DecisionBoardRowOrder")) {
                    ArrayList<ArrayList<String>> ls;
                    int lslen;
                    if (argSize > 1) {
                        throw new MousekidsProtocolException("illegal extra value(s) for DecisionBoardRowOrder: " + arg.get(1));
                    }
                    if ((lslen = (ls = InquiryFileIO.extract2DArray(inqFileSection, ++i)).size()) == 0) {
                        throw new MousekidsProtocolException("no list entry for DecisionBoardRowOrder");
                    }
                    if (ls.get(0).size() > 0) {
                        if (ls.get(0).get(0).equals("random")) {
                            if (lslen > 1) {
                                throw new MousekidsProtocolException("too many list entries for DecisionBoardRowOrder: " + (lslen - 1));
                            }
                            if (ls.get(0).size() > 1) {
                                throw new MousekidsProtocolException("illegal extra value(s) for DecisionBoardRowOrder list entry: " + ls.get(0).get(1));
                            }
                            inqFac.setDecisionBoardRowOrderRandomized(true);
                        } else {
                            ArrayList<ArrayList<Integer>> ro = new ArrayList<ArrayList<Integer>>(lslen);
                            inqFac.setDecisionBoardRowOrderRandomized(false);
                            int k = 0;
                            while (k < lslen) {
                                ArrayList<String> srcRow = ls.get(k);
                                int lskSize = srcRow.size();
                                ArrayList<Integer> ror = new ArrayList<Integer>(lskSize);
                                int l = 0;
                                while (l < lskSize) {
                                    try {
                                        ror.add(Integer.parseInt(srcRow.get(l)));
                                    }
                                    catch (NumberFormatException e) {
                                        throw new MousekidsProtocolException("not a number \"" + srcRow.get(l) + "\"");
                                    }
                                    ++l;
                                }
                                ror.add(0, 0);
                                ro.add(ror);
                                ++k;
                            }
                            inqFac.setDecisionBoardRowOrder(ro);
                        }
                    }
                }
            }
            ++i;
        }
        return inqFac;
    }

    protected static InquiryProcess extractInquiryProcess(InquiryFileSection inqFileSection) throws MousekidsProtocolException {
        InquiryProcess inqProc = new InquiryProcess();
        int nol = inqFileSection.getNumberOfLines();
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = inqFileSection.getLine(i);
            if (arg.size() > 0) {
                inqProc.addCommand(arg);
            }
            ++i;
        }
        return inqProc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static InquirySettings extractInquirySettings(InquiryFileSection inqFileSection) throws MousekidsProtocolException {
        int nol = inqFileSection.getNumberOfLines();
        int rowCount = -1;
        int columnCount = -1;
        int numberOfLearningBoards = -1;
        int numberOfDecisionBoards = -1;
        int numberOfLearningPhases = -1;
        int numberOfTrials = -1;
        ArrayList<Integer> breakAfterDB = null;
        long closingTimeout = 0L;
        String[] predictors = null;
        String[] questionnares = null;
        int touchScreen = -1;
        int instructionManual = -1;
        int highlightOption = -1;
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = inqFileSection.getLine(i);
            if (arg.size() > 0) {
                String attr = arg.get(0);
                if (attr.equals("RowCount")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing RowCount argument");
                    try {
                        rowCount = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for RowCount: " + arg.get(1));
                    }
                    if (rowCount < 1) {
                        throw new MousekidsProtocolException("RowCount too little: " + arg.get(1));
                    }
                } else if (attr.equals("ColumnCount")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing ColumnCount argument");
                    try {
                        columnCount = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for ColumnCount: " + arg.get(1));
                    }
                    if (columnCount < 1) {
                        throw new MousekidsProtocolException("ColumnCount too little: " + arg.get(1));
                    }
                } else if (attr.equals("NumberOfLearningBoards")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing NumberOfLearningBoards argument");
                    try {
                        numberOfLearningBoards = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for NumberOfLearningBoards: " + arg.get(1));
                    }
                    if (numberOfLearningBoards < 0) {
                        throw new MousekidsProtocolException("NumberOfLearningBoards too little: " + arg.get(1));
                    }
                } else if (attr.equals("NumberOfDecisionBoards")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing NumberOfDecisionBoards argument");
                    try {
                        numberOfDecisionBoards = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for NumberOfDecisionBoards: " + arg.get(1));
                    }
                    if (numberOfDecisionBoards < 1) {
                        throw new MousekidsProtocolException("NumberOfDecisionBoards too little: " + arg.get(1));
                    }
                } else if (attr.equals("Predictors")) {
                    ArrayList<String> temp = InquiryFileIO.extract1DArray(inqFileSection, ++i);
                    predictors = temp.toArray(new String[temp.size()]);
                    i += predictors.length;
                } else if (attr.equals("Questionnares")) {
                    ArrayList<String> temp = InquiryFileIO.extract1DArray(inqFileSection, ++i);
                    questionnares = temp.toArray(new String[temp.size()]);
                    i += questionnares.length;
                } else if (attr.equals("ClosingTimeout")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing ClosingTimeout argument");
                    try {
                        closingTimeout = Long.parseLong(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for closingTimeout: " + arg.get(1));
                    }
                    if (closingTimeout < 0L) {
                        throw new MousekidsProtocolException("ClosingTimeout too little: " + arg.get(1));
                    }
                } else if (attr.equals("TouchScreen")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing TouchScreen value");
                    attr = arg.get(1);
                    if (attr.equals("yes")) {
                        touchScreen = 1;
                    } else {
                        if (!attr.equals("no")) throw new MousekidsProtocolException("unkown value for TouchScreen: " + attr);
                        touchScreen = 0;
                    }
                    if (arg.size() > 2) {
                        throw new MousekidsProtocolException("too many values for TouchScreen: " + (arg.size() - 1));
                    }
                } else if (attr.equals("InstructionManual")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing InstructionManual value");
                    attr = arg.get(1);
                    if (attr.equals("yes")) {
                        instructionManual = 1;
                    } else {
                        if (!attr.equals("no")) throw new MousekidsProtocolException("unkown value for InstructionManual: " + attr);
                        instructionManual = 0;
                    }
                    if (arg.size() > 2) {
                        throw new MousekidsProtocolException("too many values for InstructionManual: " + (arg.size() - 1));
                    }
                } else if (attr.equals("HighlightOption")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing HighlightOption value");
                    attr = arg.get(1);
                    if (attr.equals("yes")) {
                        highlightOption = 1;
                    } else {
                        if (!attr.equals("no")) throw new MousekidsProtocolException("unkown value for HighlightOption: " + attr);
                        highlightOption = 0;
                    }
                    if (arg.size() > 2) {
                        throw new MousekidsProtocolException("too many values for HighlightOption: " + (arg.size() - 1));
                    }
                } else if (attr.equals("NumberOfLearningPhases")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing NumberOfLearningPhases argument");
                    try {
                        numberOfLearningPhases = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for NumberOfLearningPhases: " + arg.get(1));
                    }
                    if (numberOfLearningPhases < 0) {
                        throw new MousekidsProtocolException("NumberOfLearningPhases too little: " + arg.get(1));
                    }
                } else if (attr.equals("NumberOfTrials")) {
                    if (arg.size() <= 1) throw new MousekidsProtocolException("missing NumberOfTrials argument");
                    try {
                        numberOfTrials = Integer.parseInt(arg.get(1));
                    }
                    catch (NumberFormatException e) {
                        throw new MousekidsProtocolException("not a number for NumberOfTrails: " + arg.get(1));
                    }
                    if (numberOfTrials > numberOfDecisionBoards) {
                        throw new MousekidsProtocolException("NumberOfTrials too big: " + arg.get(1));
                    }
                } else if (attr.equals("BreakAfterDB")) {
                    breakAfterDB = new ArrayList<Integer>(0);
                    if (arg.size() > 1) {
                        int z = 1;
                        while (z < arg.size()) {
                            int n;
                            try {
                                n = Integer.parseInt(arg.get(z));
                            }
                            catch (NumberFormatException e) {
                                throw new MousekidsProtocolException("not a number for BreakAfterDB: " + arg.get(1));
                            }
                            if (n >= numberOfDecisionBoards) {
                                throw new MousekidsProtocolException("Number for BreakAfterDB is too big: " + arg.get(1));
                            }
                            breakAfterDB.add(z - 1, Integer.parseInt(arg.get(z)));
                            ++z;
                        }
                    }
                } else if (!attr.isEmpty()) {
                    throw new MousekidsProtocolException("unkown attribute: " + attr);
                }
            }
            ++i;
        }
        if (rowCount == -1) {
            throw new MousekidsProtocolException("missing RowCount");
        }
        if (columnCount == -1) {
            throw new MousekidsProtocolException("missing ColumnCount");
        }
        if (numberOfLearningBoards == -1) {
            throw new MousekidsProtocolException("missing NumberOfLearningBoards");
        }
        if (numberOfDecisionBoards == -1) {
            throw new MousekidsProtocolException("missing NumberOfDecisionBoards");
        }
        if (numberOfLearningPhases == -1) {
            throw new MousekidsProtocolException("missing NumberOfLearningPhases");
        }
        if (numberOfTrials == -1) {
            throw new MousekidsProtocolException("missing NumberOfTrials");
        }
        if (breakAfterDB == null) {
            throw new MousekidsProtocolException("missing breakAfterDB");
        }
        if (predictors == null) {
            throw new MousekidsProtocolException("missing Predictors");
        }
        if (numberOfLearningPhases <= 0 || numberOfLearningBoards >= 1) return new InquirySettings(rowCount, columnCount, numberOfLearningBoards, numberOfDecisionBoards, numberOfLearningPhases, numberOfTrials, closingTimeout, breakAfterDB, touchScreen, instructionManual, highlightOption, predictors, questionnares);
        throw new MousekidsProtocolException("If NumberOfLearningPhases is null then NumberOfLearningBoards must also be null.");
    }

    public static InquiryFileSection createProcessFileSection(InquiryProcess inqProc) {
        InquiryFileSection inqFileSec = new InquiryFileSection("PROCESS");
        int noc = inqProc.getNumberOfCommands();
        int i = 0;
        while (i < noc) {
            inqFileSec.addLine(inqProc.getCommand(i));
            ++i;
        }
        return inqFileSec;
    }

    public static void rewriteInquiryFileSection(InquiryFile inqFile, InquiryFileSection inqFileSec) {
        int nos = inqFile.getNumberOfSections();
        int i = 0;
        while (i < nos) {
            InquiryFileSection ifs = inqFile.getSection(i);
            if (ifs.getName().equals(inqFileSec.getName())) {
                inqFile.remove(ifs);
                inqFile.add(inqFileSec);
                break;
            }
            ++i;
        }
    }
}

