/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import mousekids.core.PredictionDecision;

public class InquiryProcess {
    private ArrayList<ArrayList<String>> command = new ArrayList();
    protected int[] validityPoints;
    protected int treasurePoints;
    protected Date startTime;
    protected Date endTime;
    protected Date interruptTime;
    protected SimpleDateFormat sdf;
    protected ArrayList<String> predictorsChoosen = new ArrayList();
    protected int treasurePointsFound;
    protected ArrayList<PredictionDecision> predictionDecision = new ArrayList();
    protected int rowcount;
    protected int columncount;
    protected String vpnr;
    protected String vl;

    public InquiryProcess() {
        this.sdf = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss.SSS zzz");
        int i = 0;
        while (i < 10) {
            this.predictorsChoosen.add("-1");
            ++i;
        }
    }

    public void addCommand(ArrayList<String> cmd) {
        this.command.add(cmd);
    }

    public void removeCommand(int index) {
        this.command.remove(index);
    }

    public ArrayList<String> getCommand(int index) {
        return this.command.get(index);
    }

    public int getNumberOfCommands() {
        return this.command.size();
    }

    public int[] getValidityPoints() {
        return this.validityPoints;
    }

    public int getValidityPoints(int predictor) {
        return this.validityPoints[predictor];
    }

    public int getTreasurePoints() {
        return this.treasurePoints;
    }

    public void setValidityPoints(int validityPoints, int predictor) {
        if (validityPoints < 0) {
            throw new IllegalArgumentException("number of validity points negative: " + validityPoints);
        }
        this.validityPoints[predictor] = validityPoints;
    }

    public void addValidityPoints(int validityPoints, int predictor) {
        this.setValidityPoints(this.validityPoints[predictor] + validityPoints, predictor);
    }

    public void setTreasurePoints(int treasurePoints) {
        if (treasurePoints < 0) {
            throw new IllegalArgumentException("number of treasure points negative: " + treasurePoints);
        }
        this.treasurePoints = treasurePoints;
    }

    public void addTreasurePoints(int treasurePoints) {
        this.setTreasurePoints(this.treasurePoints + treasurePoints);
    }

    public void removeAllCommands() {
        this.command.clear();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getInterruptTime() {
        return this.interruptTime;
    }

    public void setInterruptTime(Date endTime) {
        this.interruptTime = endTime;
    }

    public ArrayList<String> getPredictorsChoosen() {
        return this.predictorsChoosen;
    }

    public String getPredictorsChoosen(int position) {
        return this.predictorsChoosen.get(position);
    }

    public void setPredictorsChoosen(int position, String predictorsChoosen) {
        if (this.predictorsChoosen.get(position) != null) {
            this.predictorsChoosen.set(position, predictorsChoosen);
        } else {
            this.predictorsChoosen.add(position, predictorsChoosen);
        }
    }

    public int getTreasurePointsFound() {
        return this.treasurePointsFound;
    }

    public void setTreasurePointsFound(int treasurePointsFound) {
        this.treasurePointsFound = treasurePointsFound;
    }

    public ArrayList<PredictionDecision> getPredictionDecision() {
        return this.predictionDecision;
    }

    public PredictionDecision getPredictionDecision(int position) {
        return this.predictionDecision.get(position);
    }

    public void addPredictionDecision(int rowCount, int columnCount) {
        this.predictionDecision.add(new PredictionDecision(rowCount, columnCount));
    }

    public long getOverAllDuration() {
        if (this.endTime != null && this.startTime != null) {
            return this.endTime.getTime() - this.startTime.getTime();
        }
        if (this.interruptTime != null && this.startTime != null) {
            return this.interruptTime.getTime() - this.startTime.getTime();
        }
        return 0L;
    }

    public int getVpnr() {
        if (this.vpnr != null) {
            return Integer.parseInt(this.vpnr);
        }
        return -1;
    }

    public void setVpnr(String vpnr) {
        this.vpnr = vpnr;
    }

    public String getVL() {
        if (this.vl != null) {
            return this.vl;
        }
        return null;
    }

    public void setVL(String vl) {
        this.vl = vl;
    }

    public void extractDataInquiryProcess(int rowCount, int columnCount) {
        int nol = this.command.size();
        String dbc = null;
        int i = 0;
        while (i < nol) {
            ArrayList<String> arg = this.command.get(i);
            int argSize = arg.size();
            if (argSize > 0) {
                String val;
                String attr = arg.get(0);
                if (attr.equals("StartProcessAt")) {
                    val = arg.get(1);
                    try {
                        this.setStartTime(this.sdf.parse(val));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (attr.equals("SelectPredictor")) {
                    attr = arg.get(1);
                    val = arg.get(2);
                    this.setPredictorsChoosen(Integer.parseInt(attr), val);
                } else if (attr.equals("GotoDecisionBoard")) {
                    dbc = arg.get(1);
                    this.addPredictionDecision(rowCount, columnCount);
                } else if (attr.equals("SetPredictionDoor")) {
                    attr = arg.get(1);
                    if (attr.equals("open") && dbc != null) {
                        String row = arg.get(2);
                        String column = arg.get(3);
                        this.getPredictionDecision(Integer.parseInt(dbc)).setPredArray(Integer.parseInt(row) - 1, Integer.parseInt(column) - 1);
                        this.getPredictionDecision(Integer.parseInt(dbc)).addPrediction(Integer.parseInt(row), Integer.parseInt(column));
                    }
                } else if (attr.equals("SetHouseDoor")) {
                    attr = arg.get(1);
                    if (attr.equals("open") && dbc != null) {
                        String column = arg.get(2);
                        this.getPredictionDecision(Integer.parseInt(dbc)).setDecision(Integer.parseInt(column));
                    }
                } else if (attr.equals("DecisionDuration")) {
                    if (dbc != null) {
                        val = arg.get(1);
                        this.getPredictionDecision(Integer.parseInt(dbc)).setDuration(Integer.parseInt(val));
                    }
                } else if (attr.equals("TreasurePoints")) {
                    val = arg.get(1);
                    this.setTreasurePointsFound(Integer.parseInt(val));
                } else if (attr.equals("EndProcessAt")) {
                    val = arg.get(1);
                    try {
                        this.setEndTime(this.sdf.parse(val));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (attr.equals("InterruptProcessAt")) {
                    val = arg.get(1);
                    try {
                        this.setInterruptTime(this.sdf.parse(val));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (arg.get(0).equals("VPN")) {
                    val = arg.get(1);
                    this.setVpnr(val);
                } else if (arg.get(0).equals("VL")) {
                    val = arg.get(1);
                    this.setVL(val);
                }
            }
            ++i;
        }
    }
}

