/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.util.ArrayList;

public class InquirySettings {
    protected int rowCount;
    protected int columnCount;
    protected int numberOfLearningBoards;
    protected int numberOfDecisionBoards;
    protected int numberOfLearningPhases;
    protected int numberOfTrials;
    protected long closingTimeout;
    protected ArrayList<Integer> breakAfterDB;
    protected int touchScreen;
    protected int instructionManual;
    protected int highlightOption;
    protected String[] predictor;
    protected String[] questionnare = null;

    public InquirySettings(int rowCount, int columnCount, int numberOfLearningBoards, int numberOfDecisionBoards, int numberOfLearningPhases, int numberOfTrials, long closingTimeout, ArrayList<Integer> breakAfterDB, int touchScreen, int instructionManual, int highlightOption, String[] predictor, String[] questionnares) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.numberOfLearningBoards = numberOfLearningBoards;
        this.numberOfDecisionBoards = numberOfDecisionBoards;
        this.numberOfLearningPhases = numberOfLearningPhases;
        this.numberOfTrials = numberOfTrials;
        this.closingTimeout = closingTimeout;
        this.breakAfterDB = breakAfterDB;
        this.touchScreen = touchScreen;
        this.instructionManual = instructionManual;
        this.highlightOption = highlightOption;
        this.predictor = predictor;
        this.questionnare = questionnares;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getNumberOfLearningBoards() {
        return this.numberOfLearningBoards;
    }

    public int getNumberOfDecisionBoards() {
        return this.numberOfDecisionBoards;
    }

    public int getNumberOfLearningPhases() {
        return this.numberOfLearningPhases;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public String[] getPredictors() {
        return this.predictor;
    }

    public String getPredictor(int index) {
        return this.predictor[index];
    }

    public void setPredictor(int index, String pred) {
        this.predictor[index] = pred;
    }

    public boolean existsPredictor(String pred) {
        int i = 0;
        while (i < this.predictor.length) {
            if (this.predictor[i].equals(pred)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int positionPredictor(String pred) {
        int i = 0;
        while (i < this.predictor.length) {
            if (this.predictor[i].equals(pred)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public long getClosingTimeout() {
        return this.closingTimeout;
    }

    public ArrayList<Integer> getBreakAfterDB() {
        if (this.breakAfterDB == null) {
            return null;
        }
        return this.breakAfterDB;
    }

    public int getTouchScreen() {
        return this.touchScreen;
    }

    public int getInstructionManual() {
        return this.instructionManual;
    }

    public int getHighlightOption() {
        return this.highlightOption;
    }

    public String[] getQuestionnares() {
        if (this.questionnare == null) {
            return null;
        }
        return this.questionnare;
    }

    public String getQuestionnare(int index) {
        return this.questionnare[index];
    }

    public void setQuestionnare(int index, String ques) {
        this.questionnare[index] = ques;
    }

    public boolean existsQuestionnare(String ques) {
        int i = 0;
        while (i < this.questionnare.length) {
            if (this.questionnare[i].equals(ques)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

