/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import mousekids.core.InquiryProcess;
import mousekids.core.InquiryUserControllerListener;
import mousekids.core.Stopwatch;

public class InquiryUserControllerLogger
implements InquiryUserControllerListener {
    protected InquiryProcess inquiryProcess;
    protected Stopwatch stopwatch;
    private boolean isInDecisionPhase;
    private Date date;
    private SimpleDateFormat sdf;

    public InquiryUserControllerLogger(InquiryProcess inquiryProcess) {
        this.inquiryProcess = inquiryProcess;
        this.stopwatch = new Stopwatch();
        this.isInDecisionPhase = false;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss.SSS zzz");
    }

    private ArrayList<String> stringsToArrayList(String[] s) {
        ArrayList<String> ls = new ArrayList<String>(s.length);
        int i = 0;
        while (i < s.length) {
            ls.add(s[i]);
            ++i;
        }
        return ls;
    }

    public void log(String[] cmd) {
        this.inquiryProcess.addCommand(this.stringsToArrayList(cmd));
    }

    public void logInfo(String info) {
        this.log(new String[]{"Info", info});
    }

    public void logCurrentTimeMillis(String cmd) {
        this.date = new Date();
        this.log(new String[]{cmd, this.sdf.format(this.date)});
    }

    public void logStarted() {
        this.logCurrentTimeMillis("StartProcessAt");
    }

    public void logEnded() {
        this.logCurrentTimeMillis("EndProcessAt");
    }

    public void logInterrupted() {
        this.logCurrentTimeMillis("InterruptProcessAt");
    }

    @Override
    public void initStarted() {
    }

    @Override
    public void initEnded() {
        this.log(new String[]{""});
    }

    @Override
    public void goneToSelectionPhase() {
    }

    @Override
    public void predictorSelected(int index, String predictor) {
        this.log(new String[]{"SelectPredictor", Integer.toString(index), predictor});
    }

    @Override
    public void predictorDeselected(int index) {
        this.log(new String[]{"DeselectPredictor", Integer.toString(index)});
    }

    @Override
    public void selectionPhaseEnded() {
        this.log(new String[]{""});
        this.logStarted();
        this.log(new String[]{""});
    }

    @Override
    public void goneToLearningBoard(int learningPhaseCurrentBoard, int learningPhaseCurrentPredictor) {
        this.log(new String[]{"GotoLearningBoard", Integer.toString(learningPhaseCurrentPredictor), Integer.toString(learningPhaseCurrentBoard)});
    }

    @Override
    public void doorSet(int pred, int house, boolean open) {
        if (pred != 0) {
            this.log(new String[]{"SetPredictionDoor", open ? "open" : "closed", Integer.toString(pred), Integer.toString(house + 1)});
        } else {
            this.log(new String[]{"SetHouseDoor", open ? "open" : "closed", Integer.toString(house + 1)});
            if (this.isInDecisionPhase) {
                this.log(new String[]{"DecisionDuration", Long.toString(this.stopwatch.check())});
                this.stopwatch.reset();
            }
        }
    }

    @Override
    public void validityPointAdded(int pred, int n) {
        this.log(new String[]{"AddValidityPoint", Integer.toString(pred)});
    }

    @Override
    public void doorSelected(int pred, int house) {
        if (pred != 0) {
            this.log(new String[]{"SelectPredictionDoor", Integer.toString(pred), Integer.toString(house + 1)});
        } else {
            this.log(new String[]{"SelectHouseDoor", Integer.toString(house + 1)});
            if (this.isInDecisionPhase) {
                this.log(new String[]{"DecisionDuration", Long.toString(this.stopwatch.check())});
                this.stopwatch.reset();
            }
        }
    }

    @Override
    public void learningPhaseEnded() {
        this.log(new String[]{""});
    }

    @Override
    public void visibileTreasurePointAdded(int n) {
        this.log(new String[]{"AddTreasurePoint", Integer.toString(n)});
    }

    @Override
    public void goneToDecisionPhase() {
        this.isInDecisionPhase = true;
        this.stopwatch.start();
    }

    @Override
    public void goneToDecisionBoard(int decisionPhaseCurrentBoard) {
        this.log(new String[]{"GotoDecisionBoard", Integer.toString(decisionPhaseCurrentBoard)});
        this.stopwatch.reset();
    }

    @Override
    public void decisionPhaseEnded() {
        this.log(new String[]{""});
        this.stopwatch.stop();
        this.isInDecisionPhase = false;
        this.logEnded();
        this.log(new String[]{""});
    }

    @Override
    public void goneToFeedbackPhase(int realTreasurePoints) {
        this.log(new String[]{"ShowFeedback"});
        this.log(new String[]{"TreasurePoints", Integer.toString(realTreasurePoints)});
    }

    @Override
    public void feedbackPhaseEnded() {
        this.log(new String[]{""});
    }

    @Override
    public void terminated() {
    }

    public void resetLog() {
        this.inquiryProcess.removeAllCommands();
    }

    @Override
    public void realTreasurePointAdded(int n) {
    }

    @Override
    public void goneToAfterLearningPhase() {
    }

    @Override
    public void repeatingLearningPhase(boolean yes) {
    }

    @Override
    public void afterLearningPhaseEnded() {
    }

    @Override
    public void goneToManipulationCheckPhase() {
    }

    @Override
    public void manipulationCheckPhaseEnded() {
        this.log(new String[]{""});
    }

    @Override
    public void goneToManipulationCheckBoard() {
        this.log(new String[]{"GotoManipulationCheckBoard"});
    }

    @Override
    public void goneToQuestionnareBoard(int decisionPhaseCurrentBoard) {
        this.log(new String[]{"GotoQuestionnareBoard", Integer.toString(decisionPhaseCurrentBoard)});
    }

    @Override
    public void goneToQuestionnarePhase() {
    }

    @Override
    public void questionnarePhaseEnded() {
        this.log(new String[]{""});
    }

    @Override
    public void goneToLearningPhase(int n) {
    }

    @Override
    public void vL(String vL) {
        this.log(new String[]{"VL", vL});
    }

    @Override
    public void vPN(String vPN) {
        this.log(new String[]{"VPN", vPN});
        this.log(new String[]{""});
    }

    @Override
    public void goneToBreakBoard() {
        this.log(new String[]{"GotoBreakBoard"});
    }
}

