/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.util.ArrayList;
import mousekids.core.Prediction;

public class PredictionDecision {
    protected int decision;
    protected ArrayList<Prediction> prediction = new ArrayList();
    protected int duration;
    protected int[][] predArray;
    protected int rowCount;
    protected int columnCount;
    protected int doorOpenFreq = 0;
    protected int doorOpenOverallFreq = 0;
    protected boolean doorOpenTwice = false;
    protected int doorOpenTwiceFreq = 0;

    public PredictionDecision(int rowCount, int columnCount) {
        this.predArray = new int[rowCount][columnCount];
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                this.predArray[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public int getDecision() {
        return this.decision;
    }

    public void setDecision(int decision) {
        this.decision = decision;
    }

    public ArrayList<Prediction> getPrediction() {
        return this.prediction;
    }

    public Prediction getPrediction(int position) {
        return this.prediction.get(position);
    }

    public void addPrediction(int row, int column) {
        this.prediction.add(new Prediction(row, column));
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getPredArray(int row, int column) {
        return this.predArray[row][column];
    }

    public void setPredArray(int row, int column) {
        int[] nArray = this.predArray[row];
        int n = column;
        nArray[n] = nArray[n] + 1;
        switch (this.predArray[row][column]) {
            case 1: {
                ++this.doorOpenFreq;
                break;
            }
            case 2: {
                if (!this.doorOpenTwice) {
                    this.doorOpenTwice = true;
                }
                ++this.doorOpenTwiceFreq;
            }
        }
        ++this.doorOpenOverallFreq;
    }

    public int getDoorOpenFreq() {
        return this.doorOpenFreq;
    }

    public int getDoorOpenOverallFreq() {
        return this.doorOpenOverallFreq;
    }

    public boolean isDoorOpenTwice() {
        return this.doorOpenTwice;
    }

    public int getDoorOpenTwiceFreq() {
        return this.doorOpenTwiceFreq;
    }
}

