/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.util.ArrayList;

public class PredictionMatrix {
    private boolean[][] predictionMatrix;

    public PredictionMatrix(int rows, int columns, boolean[][] matrix) {
        if (matrix.length != rows) {
            throw new IllegalArgumentException("number of matrix rows does not match number of rows.");
        }
        int i = 0;
        while (i < matrix.length) {
            if (matrix[i].length != columns) {
                throw new IllegalArgumentException("number of matrix columns does not match number of columns.");
            }
            ++i;
        }
        this.setPredictionMatrix(matrix);
    }

    public PredictionMatrix(ArrayList<ArrayList<Boolean>> matrix) {
        this.setPredictionMatrix(matrix);
    }

    private void setPredictionMatrix(ArrayList<ArrayList<Boolean>> matrix) {
        int rows = matrix.size();
        boolean[][] res = new boolean[rows][];
        int r = 0;
        while (r < rows) {
            ArrayList<Boolean> matrixRow = matrix.get(r);
            int cols = matrixRow.size();
            boolean[] resRow = new boolean[cols];
            int c = 0;
            while (c < cols) {
                resRow[c] = matrixRow.get(c);
                ++c;
            }
            res[r] = resRow;
            ++r;
        }
        this.predictionMatrix = res;
    }

    public int getRows() {
        return this.predictionMatrix.length;
    }

    protected boolean[][] getPredictionMatrix() {
        return this.predictionMatrix;
    }

    public boolean getPrediction(int row, int column) {
        return this.predictionMatrix[row][column];
    }

    protected void setPredictionMatrix(boolean[][] matrix) {
        if (matrix.length > 0) {
            int l = matrix[0].length;
            if (l < 1) {
                throw new IllegalArgumentException("number of columns in matrix must be at least one.");
            }
            int i = 1;
            while (i < matrix.length) {
                if (matrix[i].length != l) {
                    throw new IllegalArgumentException("number of rows in matrix not constant per line.");
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("number of rows in matrix must be at least one.");
        }
        this.predictionMatrix = matrix;
    }

    public void setPrediction(int row, int column, boolean prediction) {
        this.predictionMatrix[row][column] = prediction;
    }

    public int getNumberOfColumns() {
        return this.predictionMatrix[0].length;
    }
}

