/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.util.ArrayList;

public class SelectionBoard {
    private ArrayList<String> predictorsList;
    private String[] selection;

    public SelectionBoard(String[] predictorsList, int selectionSize) {
        this.setPredictorsList(predictorsList);
        this.setSelection(new String[selectionSize]);
    }

    private void setPredictorsList(String[] predictorsList) {
        this.predictorsList = new ArrayList(predictorsList.length);
        int i = 0;
        while (i < predictorsList.length) {
            this.predictorsList.add(predictorsList[i]);
            ++i;
        }
    }

    public String[] getPredictorsList() {
        return (String[])this.predictorsList.toArray();
    }

    private void setSelection(String[] selection) {
        this.selection = selection;
    }

    public String[] getSelection() {
        return this.selection;
    }

    public int getSelectionSize() {
        return this.selection.length;
    }

    public String getSelection(int n) {
        return this.selection[n];
    }

    public int getPredictorsListSize() {
        return this.predictorsList.size();
    }

    public String getPredictor(int n) {
        return this.predictorsList.get(n);
    }

    public boolean chosePredictor(String predictor, int selectionPos) {
        if (this.selection[selectionPos] == null) {
            int i = 0;
            while (i < this.predictorsList.size()) {
                if (this.predictorsList.get(i).equals(predictor)) {
                    this.predictorsList.remove(i);
                    this.selection[selectionPos] = predictor;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean rejectPredictor(String predictor, int rejectionPos) {
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].equals(predictor)) {
                this.predictorsList.add(this.selection[i]);
                this.selection[i] = null;
                return true;
            }
            ++i;
        }
        return false;
    }
}

