/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

public class SessionState {
    protected int phase = 0;
    public static final int PHASE_INIT = 0;
    public static final int PHASE_SELECTION = 1;
    public static final int PHASE_LEARNING = 2;
    public static final int PHASE_AFTER_LEARNING = 3;
    public static final int PHASE_MANIPULATION_CHECK = 4;
    public static final int PHASE_QUESTIONNARE = 5;
    public static final int PHASE_DECISION = 6;
    public static final int PHASE_FEEDBACK = 7;
    public static final int PHASE_TERMINATED = -1;
    public static final int REPEATING_LEARNING_PHASE_NOT_DECIDED = 0;
    public static final int REPEATING_LEARNING_PHASE_YES = 1;
    public static final int REPEATING_LEARNING_PHASE_NO = 2;
    protected int learningPhaseCurrentPhase = -1;
    protected int learningPhaseCurrentPredictor = -1;
    protected int learningPhaseCurrentBoard = -1;
    protected int decisionPhaseCurrentBoard = -1;
    protected boolean predictionDoorsChangeable = false;
    protected boolean houseDoorsChangeable = false;
    protected boolean houseDoorsSelectable = false;
    protected boolean validityPointSettable = false;
    protected boolean treasurePointSettable = false;
    protected boolean treasurePointVisible = false;
    protected boolean treasureFound = false;
    protected String[] selectedPredictors;
    protected boolean[][] doorMatrix;
    protected boolean[][] outcomeTrivial;
    protected int numberOfVisibleTreasurePoints = 0;
    protected int numberOfRealTreasurePoints = 0;
    protected int[] numberOfValidityPoints;
    protected boolean executingClosing;
    protected int repeatingLearningPhaseChosen = 0;
    protected boolean decisionPhaseOver = false;
    protected String[] availablePredictors;
    protected int tempPred;
    protected int tempHouse;
    protected boolean isSecondDoor = false;
    protected boolean isBreak = false;
    protected boolean isBreakAfterTrials = false;
    protected boolean isBreakAfterLastDecision = false;
    protected boolean showBreak = false;
    protected boolean showBreakAfterTrialsBoard = false;
    protected boolean showBreakAfterLastDecisionBoard = false;
    protected boolean firstHouseOpened = false;
    protected int houseCounter = 0;
    protected boolean highlightOption = false;

    public SessionState(int numberOfSelectablePredictors, int columns, String[] availablePredictors) {
        this.selectedPredictors = new String[numberOfSelectablePredictors + 1];
        this.availablePredictors = availablePredictors;
        this.numberOfValidityPoints = new int[numberOfSelectablePredictors + 1];
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getLearningPhaseCurrentPhase() {
        return this.learningPhaseCurrentPhase;
    }

    public void setLearningPhaseCurrentPhase(int learningPhaseCurrentPhase) {
        this.learningPhaseCurrentPhase = learningPhaseCurrentPhase;
    }

    public int getLearningPhaseCurrentPredictor() {
        return this.learningPhaseCurrentPredictor;
    }

    public void setLearningPhaseCurrentPredictor(int learningPhaseCurrentPredictor) {
        this.learningPhaseCurrentPredictor = learningPhaseCurrentPredictor;
    }

    public int getLearningPhaseCurrentBoard() {
        return this.learningPhaseCurrentBoard;
    }

    public void setLearningPhaseCurrentBoard(int learningPhaseCurrentBoard) {
        this.learningPhaseCurrentBoard = learningPhaseCurrentBoard;
    }

    public int getDecisionPhaseCurrentBoard() {
        return this.decisionPhaseCurrentBoard;
    }

    public void setDecisionPhaseCurrentBoard(int decisionPhaseCurrentBoard) {
        this.decisionPhaseCurrentBoard = decisionPhaseCurrentBoard;
    }

    public String getSelectedPredictor(int index) {
        return this.selectedPredictors[index];
    }

    public void setSelectedPredictor(int index, String predictor) {
        this.selectedPredictors[index] = predictor;
    }

    public boolean isPredictionDoorChangeable() {
        return this.predictionDoorsChangeable && !this.executingClosing;
    }

    public void setPredictionDoorsChangeable(boolean learningPhasePredictionOpened) {
        this.predictionDoorsChangeable = learningPhasePredictionOpened;
    }

    public boolean isValidityPointSettable() {
        return this.validityPointSettable;
    }

    public void setValidityPointSettable(boolean learningPhaseValidityPointSet) {
        this.validityPointSettable = learningPhaseValidityPointSet;
    }

    public boolean isHouseDoorsChangeable() {
        return this.houseDoorsChangeable && !this.executingClosing;
    }

    public void setHouseDoorsChangeable(boolean doorsOpenable) {
        this.houseDoorsChangeable = doorsOpenable;
    }

    public boolean isTreasurePointSettable() {
        return this.treasurePointSettable;
    }

    public void setTreasurePointSettable(boolean treasurePointSettable) {
        this.treasurePointSettable = treasurePointSettable;
    }

    public void setAllDoors(boolean open) {
        this.setPredictionDoors(open);
        this.setHouseDoors(open);
    }

    public void setPredictionDoors(boolean open) {
        int i = 1;
        while (i < this.doorMatrix.length) {
            int j = 0;
            while (j < this.doorMatrix[i].length) {
                this.setDoor(i, j, open);
                ++j;
            }
            ++i;
        }
    }

    public void setHouseDoors(boolean open) {
        int i = 0;
        while (i < this.doorMatrix[0].length) {
            this.setDoor(0, i, open);
            ++i;
        }
    }

    public void setDoor(int row, int column, boolean open) {
        this.doorMatrix[row][column] = open;
    }

    protected boolean[][] getDoorMatrix() {
        return this.doorMatrix;
    }

    public boolean getDoor(int row, int column) {
        return this.doorMatrix[row][column];
    }

    public boolean isHouseDoorsSelectable() {
        return this.houseDoorsSelectable;
    }

    public void setHouseDoorsSelectable(boolean houseDoorsSelectable) {
        this.houseDoorsSelectable = houseDoorsSelectable;
    }

    public boolean isTreasurePointVisible() {
        return this.treasurePointVisible;
    }

    public void setTreasurePointVisible(boolean treasurePointVisible) {
        this.treasurePointVisible = treasurePointVisible;
    }

    public int getNumberOfVisibleTreasurePoints() {
        return this.numberOfVisibleTreasurePoints;
    }

    public void setNumberOfVisibleTreasurePoints(int numberOfTreasurePoints) {
        this.numberOfVisibleTreasurePoints = numberOfTreasurePoints;
    }

    public void setNumberOfValidityPoints(int index, int numberOfValidityPoints) {
        this.numberOfValidityPoints[index] = numberOfValidityPoints;
    }

    public boolean isNextable() {
        switch (this.phase) {
            case 0: {
                return true;
            }
            case 1: {
                int i = 1;
                while (i < this.selectedPredictors.length) {
                    if (this.selectedPredictors[i] == null) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 2: {
                return !this.predictionDoorsChangeable && !this.houseDoorsChangeable && !this.validityPointSettable;
            }
            case 3: {
                return this.repeatingLearningPhaseChosen != 0;
            }
            case 4: {
                return !this.predictionDoorsChangeable && !this.houseDoorsChangeable && !this.treasurePointSettable;
            }
            case 5: {
                return !this.predictionDoorsChangeable && !this.houseDoorsChangeable && !this.treasurePointSettable;
            }
            case 6: {
                return !this.predictionDoorsChangeable && !this.houseDoorsChangeable && !this.treasurePointSettable;
            }
            case 7: {
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    public int getNumberOfValidityPoints(int effectiveRow) {
        return this.numberOfValidityPoints[effectiveRow];
    }

    public int getNumberOfRealTreasurePoints() {
        return this.numberOfRealTreasurePoints;
    }

    public void setNumberOfRealTreasurePoints(int numberOfRealTreasurePoints) {
        this.numberOfRealTreasurePoints = numberOfRealTreasurePoints;
    }

    public boolean isOutcomeTrivial(int row, int column) {
        return this.outcomeTrivial[row][column];
    }

    public void setOutcomeTrivial(int row, int column, boolean outcomeTrivial) {
        this.outcomeTrivial[row][column] = outcomeTrivial;
    }

    public void createDoorMatrix(int rows, int cols) {
        this.doorMatrix = new boolean[rows][cols];
        this.outcomeTrivial = new boolean[rows][cols];
    }

    public int getNumberOfDoorRows() {
        return this.doorMatrix.length;
    }

    public int getNumberOfDoorColumns(int row) {
        return this.doorMatrix[row].length;
    }

    public int getNumberOfDoorColumns() {
        return this.doorMatrix[0].length;
    }

    public void setHouseOutcomeTrivial(boolean b) {
        int i = 0;
        while (i < this.outcomeTrivial[0].length) {
            this.outcomeTrivial[0][i] = b;
            ++i;
        }
    }

    public void setPredictionOutcomeTrivial(boolean b) {
        int i = 1;
        while (i < this.outcomeTrivial.length) {
            int j = 0;
            while (j < this.outcomeTrivial[i].length) {
                this.outcomeTrivial[i][j] = b;
                ++j;
            }
            ++i;
        }
    }

    public void setAllOutcomeTrivial(boolean value) {
        this.setHouseOutcomeTrivial(value);
        this.setPredictionOutcomeTrivial(value);
    }

    public boolean isTreasureFound() {
        return this.treasureFound;
    }

    public void setTreasureFound(boolean treasureFound) {
        this.treasureFound = treasureFound;
    }

    public boolean isExecutingClosing() {
        return this.executingClosing;
    }

    public void setExecutingClosing(boolean executingClosing) {
        this.executingClosing = executingClosing;
    }

    public int getRepeatingLearningPhaseChosen() {
        return this.repeatingLearningPhaseChosen;
    }

    public void setRepeatingLearningPhaseChosen(int repeatingLearningPhaseChosen) {
        this.repeatingLearningPhaseChosen = repeatingLearningPhaseChosen;
    }

    public void resetValidityPoints() {
        int i = 1;
        while (i < this.numberOfValidityPoints.length) {
            this.setNumberOfValidityPoints(i, 0);
            ++i;
        }
    }

    public boolean isDecisionPhaseOver() {
        return this.decisionPhaseOver;
    }

    public void setDecisionPhaseOver(boolean decisionPhaseOver) {
        this.decisionPhaseOver = decisionPhaseOver;
    }

    public int getTempPred() {
        return this.tempPred;
    }

    public void setTempPred(int tempPred) {
        this.tempPred = tempPred;
    }

    public int getTempHouse() {
        return this.tempHouse;
    }

    public void setTempHouse(int tempHouse) {
        this.tempHouse = tempHouse;
    }

    public boolean isSecondDoor() {
        return this.isSecondDoor;
    }

    public void setSecondDoor(boolean isSecondDoor) {
        this.isSecondDoor = isSecondDoor;
    }

    public boolean isBreak() {
        return this.isBreak;
    }

    public void setBreak(boolean isBreak) {
        this.isBreak = isBreak;
    }

    public boolean isShowBreak() {
        return this.showBreak;
    }

    public void setShowBreak(boolean showBreak) {
        this.showBreak = showBreak;
    }

    public boolean isBreakAfterTrials() {
        return this.isBreakAfterTrials;
    }

    public void setBreakAfterTrials(boolean isBreakAfterTrials) {
        this.isBreakAfterTrials = isBreakAfterTrials;
    }

    public boolean isBreakAfterLastDecision() {
        return this.isBreakAfterLastDecision;
    }

    public void setBreakAfterLastDecision(boolean isBreakAfterLastDecision) {
        this.isBreakAfterLastDecision = isBreakAfterLastDecision;
    }

    public boolean isShowBreakAfterTrialsBoard() {
        return this.showBreakAfterTrialsBoard;
    }

    public void setShowBreakAfterTrialsBoard(boolean showBreakAfterTrialsBoard) {
        this.showBreakAfterTrialsBoard = showBreakAfterTrialsBoard;
    }

    public boolean isShowBreakAfterLastDecisionBoard() {
        return this.showBreakAfterLastDecisionBoard;
    }

    public void setShowBreakAfterLastDecisionBoard(boolean showBreakAfterLastDecisionBoard) {
        this.showBreakAfterLastDecisionBoard = showBreakAfterLastDecisionBoard;
    }

    public boolean isFirstHouseOpened() {
        return this.firstHouseOpened;
    }

    public void setFirstHouseOpened(boolean firstHouseOpened) {
        this.firstHouseOpened = firstHouseOpened;
    }

    public int getHouseCounter() {
        return this.houseCounter;
    }

    public void setHouseCounter(int houseCounter) {
        this.houseCounter = houseCounter;
    }

    public boolean isHighlightOption() {
        return this.highlightOption;
    }

    public void setHighlightOption(boolean highlightOption) {
        this.highlightOption = highlightOption;
    }
}

