/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import mousekids.core.Inquiry;
import mousekids.core.SessionState;
import mousekids.core.SessionStateReflector;

public class SimpleSessionStateReflector
implements SessionStateReflector {
    protected Inquiry inquiry;
    protected SessionState sessionState;

    public SimpleSessionStateReflector(Inquiry inquiry, SessionState sessionState) {
        this.inquiry = inquiry;
        this.sessionState = sessionState;
    }

    @Override
    public int getBoardToDisplay() {
        switch (this.sessionState.getPhase()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                if (this.sessionState.isShowBreakAfterTrialsBoard()) {
                    this.sessionState.setShowBreakAfterTrialsBoard(false);
                    return 5;
                }
                if (this.sessionState.isShowBreak()) {
                    this.sessionState.setShowBreak(false);
                    return 5;
                }
                if (this.sessionState.isShowBreakAfterLastDecisionBoard()) {
                    this.sessionState.setShowBreakAfterTrialsBoard(false);
                    return 5;
                }
                return 2;
            }
            case 7: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public boolean isNextable() {
        return this.sessionState.isNextable();
    }

    @Override
    public int getNumberOfAvailablePredictors() {
        return this.inquiry.getSettings().getPredictors().length;
    }

    @Override
    public String getAvailablePredictor(int index) {
        return this.inquiry.getSettings().getPredictor(index);
    }

    @Override
    public int getNumberOfSelectablePredictors() {
        return this.inquiry.getSettings().getRowCount();
    }

    @Override
    public int getNumberOfHouses() {
        return this.inquiry.getSettings().getColumnCount();
    }

    @Override
    public int getNumberOfDecisionBoards() {
        return this.inquiry.getSettings().getNumberOfDecisionBoards();
    }

    @Override
    public int getNumberOfLearningBoards() {
        return this.inquiry.getSettings().getNumberOfLearningBoards();
    }

    @Override
    public int getNumberOfVisibleTreasurePoints() {
        return this.sessionState.getNumberOfVisibleTreasurePoints();
    }

    @Override
    public int getNumberOfValidityPoints(int visibleRow) {
        return this.sessionState.getNumberOfValidityPoints(this.getInquiryPredictionRow(visibleRow));
    }

    private int getFriendRow(int inquiryRow) {
        return inquiryRow;
    }

    private int getInquiryRow(int visibleRow) {
        switch (this.sessionState.getPhase()) {
            case 2: {
                return visibleRow;
            }
            case 4: {
                return visibleRow;
            }
            case 5: {
                return visibleRow;
            }
            case 6: {
                return this.inquiry.getFactors().getDecisionBoardRowOrder().get(this.sessionState.getDecisionPhaseCurrentBoard()).get(visibleRow);
            }
        }
        return -1;
    }

    private int getInquiryPredictorRow(int visibleRow) {
        return this.getFriendRow(this.getInquiryRow(visibleRow));
    }

    @Override
    public int getInquiryPredictionRow(int visibleRow) {
        return this.getInquiryRow(visibleRow);
    }

    @Override
    public String getMatrixPredictor(int visibleRow) {
        return this.sessionState.getSelectedPredictor(this.getInquiryPredictorRow(visibleRow));
    }

    @Override
    public boolean isDoorOpen(int visibleRow, int column) {
        return this.sessionState.getDoor(this.getInquiryPredictionRow(visibleRow), column);
    }

    @Override
    public boolean isTreasureHere(int visibleRow, int column) {
        switch (this.sessionState.getPhase()) {
            case 2: {
                if (this.getInquiryPredictionRow(visibleRow) == 0) {
                    return this.inquiry.getLearningBoards().getPredictionMatrix(this.sessionState.getLearningPhaseCurrentBoard()).getPrediction(this.getInquiryPredictionRow(visibleRow), this.sessionState.getLearningPhaseCurrentPredictor() - 1);
                }
                return this.inquiry.getLearningBoards().getPredictionMatrix(this.sessionState.getLearningPhaseCurrentBoard()).getPrediction(this.getInquiryPredictionRow(visibleRow), column);
            }
            case 4: {
                return this.inquiry.getDecisionBoards().getPredictionMatrix(this.sessionState.getDecisionPhaseCurrentBoard()).getPrediction(this.getInquiryPredictionRow(visibleRow), column);
            }
            case 5: {
                return this.inquiry.getDecisionBoards().getPredictionMatrix(this.sessionState.getDecisionPhaseCurrentBoard()).getPrediction(this.getInquiryPredictionRow(visibleRow), column);
            }
            case 6: {
                return this.inquiry.getDecisionBoards().getPredictionMatrix(this.sessionState.getDecisionPhaseCurrentBoard()).getPrediction(this.getInquiryPredictionRow(visibleRow), column);
            }
        }
        return false;
    }

    @Override
    public boolean isDoorChangeable(int visibleRow, int column) {
        int inqRow = this.getInquiryPredictionRow(visibleRow);
        if (inqRow == 0) {
            return this.sessionState.isHouseDoorsChangeable();
        }
        switch (this.sessionState.getPhase()) {
            case 2: {
                return this.sessionState.isPredictionDoorChangeable() && inqRow == this.sessionState.getLearningPhaseCurrentPredictor();
            }
            case 4: {
                return this.sessionState.isPredictionDoorChangeable();
            }
            case 5: {
                return this.sessionState.isPredictionDoorChangeable();
            }
            case 6: {
                return this.sessionState.isPredictionDoorChangeable();
            }
        }
        return false;
    }

    @Override
    public boolean isDoorSelectable(int visibleRow, int column) {
        int inqRow = this.getInquiryPredictionRow(visibleRow);
        if (inqRow == 0) {
            return this.sessionState.isHouseDoorsSelectable();
        }
        return false;
    }

    @Override
    public boolean isValidityPointSettable(int visibleRow) {
        int inqRow = this.getInquiryPredictionRow(visibleRow);
        if (inqRow == 0) {
            return false;
        }
        switch (this.sessionState.getPhase()) {
            case 2: {
                return this.sessionState.isValidityPointSettable() && inqRow == this.sessionState.getLearningPhaseCurrentPredictor();
            }
            case 4: {
                return this.sessionState.isValidityPointSettable();
            }
            case 5: {
                return this.sessionState.isValidityPointSettable();
            }
            case 6: {
                return this.sessionState.isValidityPointSettable();
            }
        }
        return false;
    }

    @Override
    public boolean isTreasurePointSettable() {
        return this.sessionState.isTreasurePointSettable();
    }

    @Override
    public boolean isTreasurePointVisible() {
        return this.sessionState.isTreasurePointVisible();
    }

    @Override
    public int getNumberOfRealTreasurePoints() {
        return this.sessionState.getNumberOfRealTreasurePoints();
    }

    @Override
    public boolean isOutcomeTrivial(int visibleRow, int column) {
        return this.sessionState.isOutcomeTrivial(this.getInquiryPredictorRow(visibleRow), column);
    }

    @Override
    public int getNumberOfDoorRows() {
        return this.sessionState.getNumberOfDoorRows();
    }

    @Override
    public int getNumberOfDoorColumns(int row) {
        return this.sessionState.getNumberOfDoorColumns(row);
    }

    @Override
    public int getNumberOfDoorColumns() {
        return this.sessionState.getNumberOfDoorColumns();
    }

    @Override
    public boolean isTreasureFound() {
        return this.sessionState.isTreasureFound();
    }

    @Override
    public boolean isPredictorOver() {
        return this.getNumberOfLearningBoards() - 1 == this.sessionState.getLearningPhaseCurrentBoard() && this.sessionState.getPhase() == 2;
    }

    @Override
    public boolean isTouchScreen() {
        return this.inquiry.getSettings().getTouchScreen() == 1;
    }

    @Override
    public int getLearningPhaseCurrentPredictor() {
        if (this.sessionState.getPhase() == 2) {
            return this.sessionState.getLearningPhaseCurrentPredictor();
        }
        return -1;
    }

    @Override
    public String getMatrixQuestionnare(int index) {
        return this.inquiry.getSettings().getQuestionnare(index);
    }

    @Override
    public int getQuestionnarePhaseCurrentQuestionnare() {
        if (this.sessionState.getPhase() == 5) {
            return this.sessionState.getDecisionPhaseCurrentBoard();
        }
        return -1;
    }

    @Override
    public boolean isLearningPhaseOver() {
        return this.inquiry.getSettings().getNumberOfLearningPhases() != this.sessionState.getLearningPhaseCurrentPhase();
    }

    @Override
    public int getNumberOfTrials() {
        return this.inquiry.getSettings().getNumberOfTrials();
    }

    @Override
    public boolean isLastDecisionOver() {
        return this.sessionState.isBreakAfterLastDecision();
    }

    @Override
    public boolean isTrialOver() {
        return this.sessionState.isBreakAfterTrials();
    }

    @Override
    public boolean isBreak() {
        return this.sessionState.isBreak();
    }

    @Override
    public boolean isInstructionManual() {
        return this.inquiry.getSettings().getInstructionManual() == 1;
    }

    @Override
    public boolean isHighlightOption() {
        return this.inquiry.getSettings().getHighlightOption() == 1 && this.sessionState.getPhase() == 6;
    }
}

