/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

public class Stopwatch {
    protected long startedAt = 0L;
    protected long stoppedAt = 0L;
    protected long pausedTime = 0L;
    protected long lastDiffAt = 0L;
    protected boolean stopped = true;

    public Stopwatch() {
        this.reset();
    }

    public void reset() {
        this.stoppedAt = this.startedAt = System.currentTimeMillis();
        this.lastDiffAt = this.startedAt;
        this.pausedTime = 0L;
    }

    public long check() {
        return (this.stopped ? this.stoppedAt : System.currentTimeMillis()) - this.startedAt - this.pausedTime;
    }

    public long diff() {
        long c = this.check();
        long d = c - this.lastDiffAt;
        this.lastDiffAt = c;
        return d;
    }

    public void start() {
        if (this.stopped) {
            this.pausedTime += System.currentTimeMillis() - this.stoppedAt;
            this.stopped = false;
        }
    }

    public void stop() {
        if (!this.stopped) {
            this.stoppedAt = System.currentTimeMillis();
            this.stopped = true;
        }
    }
}

