/*
 * Decompiled with CFR 0.152.
 */
package mousekids.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import mousekids.core.Inquiry;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WriteExcel {
    private ArrayList<String> var;
    private Sheet sheet;
    private Workbook workbook;
    private FileOutputStream fos;
    private Row hssfrow;
    private Cell hssfcell;

    public WriteExcel(File outFile) throws IOException {
        this.fos = new FileOutputStream(outFile);
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet("SPSS");
    }

    public void create(Inquiry inquiry, int n) throws WriteException {
        this.createVariables(inquiry, n);
        this.createValues(inquiry, n);
    }

    public void write() throws WriteException, IOException {
        this.workbook.write((OutputStream)this.fos);
        this.fos.flush();
        this.fos.close();
    }

    private void createVariables(Inquiry inquiry, int n) throws WriteException {
        int j;
        this.var = new ArrayList();
        this.var.add("VP");
        this.var.add("VisibilityFactor");
        this.var.add("ImmediateFeedbackFactor");
        this.var.add("NumberOfLearningPhases");
        this.var.add("NumberOfTrails");
        this.var.add("InstructionManual");
        this.var.add("HighlightOption");
        int i = 1;
        while (i <= inquiry.getSettings().getRowCount()) {
            this.var.add("Cue" + i);
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            this.var.add("D" + i + "_Choice");
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            j = 1;
            while (j <= inquiry.getSettings().getRowCount() * inquiry.getSettings().getColumnCount() * 2) {
                this.var.add("D" + i + "_Door" + j);
                ++j;
            }
            this.var.add("D" + i + "_open");
            this.var.add("D" + i + "_open_freq");
            this.var.add("D" + i + "_open_twice");
            this.var.add("D" + i + "_open_twice_freq");
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            this.var.add("D" + i + "_time");
            ++i;
        }
        this.var.add("total_time");
        i = 1;
        while (i <= inquiry.getSettings().getRowCount()) {
            j = 1;
            while (j <= inquiry.getSettings().getNumberOfDecisionBoards()) {
                int o = 1;
                while (o <= inquiry.getSettings().getColumnCount()) {
                    this.var.add("D" + j + "_Cue" + i + "_Prediction" + o);
                    ++o;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            j = 1;
            while (j <= inquiry.getSettings().getColumnCount()) {
                this.var.add("D" + i + "_Outcome" + j);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfLearningBoards()) {
            j = 1;
            while (j <= inquiry.getSettings().getRowCount()) {
                this.var.add("L" + i + "_Cue" + j + "_Prediction");
                this.var.add("L" + i + "_Cue" + j + "_Outcome");
                ++j;
            }
            ++i;
        }
        if (n == 0) {
            this.hssfrow = this.sheet.createRow(n);
            i = 0;
            while (i < this.var.size()) {
                this.addVariables(i, 0, this.var.get(i));
                ++i;
            }
        }
    }

    private void createValues(Inquiry inquiry, int n) throws WriteException, RowsExceededException {
        int j;
        int row = n + 1;
        int misval = -66;
        this.hssfrow = this.sheet.createRow(n + 1);
        if (inquiry.getProcess().getVpnr() != -1) {
            this.addInt(this.var.indexOf("VP"), row, inquiry.getProcess().getVpnr());
        }
        this.addString(this.var.indexOf("VisibilityFactor"), row, inquiry.getFactors().getVisibility().name());
        this.addString(this.var.indexOf("ImmediateFeedbackFactor"), row, inquiry.getFactors().getImmediateFeedback().name());
        this.addInt(this.var.indexOf("NumberOfLearningPhases"), row, inquiry.getSettings().getNumberOfLearningPhases());
        this.addInt(this.var.indexOf("NumberOfTrails"), row, inquiry.getSettings().getNumberOfLearningPhases());
        if (inquiry.getSettings().getInstructionManual() != -1) {
            this.addInt(this.var.indexOf("InstructionManual"), row, inquiry.getSettings().getInstructionManual());
        } else {
            this.addInt(this.var.indexOf("InstructionManual"), row, misval);
        }
        if (inquiry.getSettings().getHighlightOption() != -1) {
            this.addInt(this.var.indexOf("HighlightOption"), row, inquiry.getSettings().getHighlightOption());
        } else {
            this.addInt(this.var.indexOf("HighlightOption"), row, misval);
        }
        int i = 1;
        while (i <= inquiry.getSettings().getRowCount()) {
            if (!inquiry.getProcess().getPredictorsChoosen().isEmpty()) {
                if (inquiry.getProcess().getPredictorsChoosen(i) != null) {
                    this.addInt(this.var.indexOf("Cue" + i), row, inquiry.getSettings().positionPredictor(inquiry.getProcess().getPredictorsChoosen(i)));
                } else {
                    this.addInt(this.var.indexOf("Cue" + i), row, misval);
                }
            } else {
                this.addInt(this.var.indexOf("Cue" + i), row, misval);
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            if (!inquiry.getProcess().getPredictionDecision().isEmpty()) {
                if (inquiry.getProcess().getPredictionDecision().size() > i - 1) {
                    this.addInt(this.var.indexOf("D" + i + "_Choice"), row, inquiry.getProcess().getPredictionDecision(i - 1).getDecision());
                } else {
                    this.addInt(this.var.indexOf("D" + i + "_Choice"), row, misval);
                }
            } else {
                this.addInt(this.var.indexOf("D" + i + "_Choice"), row, misval);
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            boolean mis = false;
            boolean mis2 = true;
            int j2 = 1;
            while (j2 <= inquiry.getSettings().getRowCount() * inquiry.getSettings().getColumnCount() * 2) {
                if (!inquiry.getProcess().getPredictionDecision().isEmpty()) {
                    if (inquiry.getProcess().getPredictionDecision().size() > i - 1) {
                        if (!inquiry.getProcess().getPredictionDecision(i - 1).getPrediction().isEmpty()) {
                            if (inquiry.getProcess().getPredictionDecision(i - 1).getPrediction().size() > j2 - 1) {
                                this.addInt(this.var.indexOf("D" + i + "_Door" + j2), row, inquiry.getProcess().getPredictionDecision(i - 1).getPrediction(j2 - 1).getCode());
                                mis2 = false;
                            } else {
                                mis = true;
                            }
                        } else {
                            mis = true;
                        }
                    } else {
                        mis = true;
                    }
                } else {
                    mis = true;
                }
                if (mis) {
                    this.addInt(this.var.indexOf("D" + i + "_Door" + j2), row, misval);
                }
                ++j2;
            }
            if (mis2) {
                this.addInt(this.var.indexOf("D" + i + "_open"), row, misval);
                this.addInt(this.var.indexOf("D" + i + "_open_freq"), row, misval);
                this.addInt(this.var.indexOf("D" + i + "_open_twice"), row, misval);
                this.addInt(this.var.indexOf("D" + i + "_open_twice_freq"), row, misval);
            } else {
                this.addInt(this.var.indexOf("D" + i + "_open"), row, inquiry.getProcess().getPredictionDecision(i - 1).getDoorOpenFreq());
                this.addInt(this.var.indexOf("D" + i + "_open_freq"), row, inquiry.getProcess().getPredictionDecision(i - 1).getDoorOpenOverallFreq());
                this.addInt(this.var.indexOf("D" + i + "_open_twice"), row, inquiry.getProcess().getPredictionDecision(i - 1).isDoorOpenTwice() ? 1 : 0);
                this.addInt(this.var.indexOf("D" + i + "_open_twice_freq"), row, inquiry.getProcess().getPredictionDecision(i - 1).getDoorOpenTwiceFreq());
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            if (!inquiry.getProcess().getPredictionDecision().isEmpty()) {
                if (inquiry.getProcess().getPredictionDecision().size() > i - 1) {
                    this.addInt(this.var.indexOf("D" + i + "_time"), row, inquiry.getProcess().getPredictionDecision(i - 1).getDuration());
                } else {
                    this.addInt(this.var.indexOf("D" + i + "_time"), row, misval);
                }
            } else {
                this.addInt(this.var.indexOf("D" + i + "_time"), row, misval);
            }
            ++i;
        }
        this.addInt(this.var.indexOf("total_time"), row, (int)inquiry.getProcess().getOverAllDuration());
        i = 1;
        while (i <= inquiry.getSettings().getRowCount()) {
            j = 1;
            while (j <= inquiry.getSettings().getNumberOfDecisionBoards()) {
                int o = 1;
                while (o <= inquiry.getSettings().getColumnCount()) {
                    this.addInt(this.var.indexOf("D" + j + "_Cue" + i + "_Prediction" + o), row, inquiry.getDecisionBoards().getPredictionMatrix(j - 1).getPrediction(i, o - 1) ? 1 : 0);
                    ++o;
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfDecisionBoards()) {
            j = 1;
            while (j <= inquiry.getSettings().getColumnCount()) {
                this.addInt(this.var.indexOf("D" + i + "_Outcome" + j), row, inquiry.getDecisionBoards().getPredictionMatrix(i - 1).getPrediction(0, j - 1) ? 1 : 0);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= inquiry.getSettings().getNumberOfLearningBoards()) {
            j = 1;
            while (j <= inquiry.getSettings().getRowCount()) {
                this.addInt(this.var.indexOf("L" + i + "_Cue" + j + "_Prediction"), row, inquiry.getLearningBoards().getPredictionMatrix(i - 1).getPrediction(j, 0) ? 1 : 0);
                this.addInt(this.var.indexOf("L" + i + "_Cue" + j + "_Outcome"), row, inquiry.getLearningBoards().getPredictionMatrix(i - 1).getPrediction(0, j - 1) ? 1 : 0);
                ++j;
            }
            ++i;
        }
    }

    private void addVariables(int column, int row, String s) throws RowsExceededException, WriteException {
        this.hssfcell = this.hssfrow.createCell(column);
        this.hssfcell.setCellValue(s);
    }

    private void addInt(int column, int row, Integer integer) throws WriteException, RowsExceededException {
        this.hssfcell = this.hssfrow.createCell(column);
        this.hssfcell.setCellValue((double)integer.intValue());
    }

    private void addString(int column, int row, String s) throws WriteException, RowsExceededException {
        this.hssfcell = this.hssfrow.createCell(column);
        this.hssfcell.setCellValue(s);
    }
}

