/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AlignGridLayout;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;

public class AfterLearningPhaseBoard
extends Board {
    private JButton nextButton = new JButton("continue");

    public AfterLearningPhaseBoard(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, Object nextChosen, BoardStyle boardStyle) {
        super(inqCtrl, sessionStateReflector, nextChosen, boardStyle);
        this.component = new JPanel(new AlignGridLayout(new double[]{1.0}, new double[]{0.125, 0.8, 0.075}), true);
        this.nextButton.addActionListener(new RepeatActionEventHandler(nextChosen, sessionStateReflector.isLearningPhaseOver()));
        this.component.add("0x2", this.nextButton);
        this.updateNextButton();
    }

    private void updateNextButton() {
        if (!this.sessionStateReflector.isLearningPhaseOver()) {
            this.nextButton.setBackground(Color.LIGHT_GRAY);
            this.nextButton.repaint();
        }
    }

    private class RepeatActionEventHandler
    implements ActionListener {
        private Object nextChosen;
        private boolean repeat;

        public RepeatActionEventHandler(Object nextChosen, boolean repeat) {
            this.nextChosen = nextChosen;
            this.repeat = repeat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            AfterLearningPhaseBoard.this.inqCtrl.repeatLearningPhase(this.repeat);
            Object object = this.nextChosen;
            synchronized (object) {
                this.nextChosen.notify();
            }
        }
    }
}

