/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;

public class AlignGridLayout
implements LayoutManager {
    private ArrayList<Component> components = new ArrayList();
    private ArrayList<Loc> locs = new ArrayList();
    private double[] horizontalAlignment;
    private double[] verticalAlignment;
    private double horizontalAbsSum = 0.0;
    private double verticalAbsSum;
    private double horizontalRelSum;
    private double verticalRelSum;
    private int nextX = 0;
    private int nextY = 0;
    private int locsX;
    private int locsY;

    public AlignGridLayout(double[] horizontalAlignment, double[] verticalAlignment) {
        int i = 0;
        while (i < horizontalAlignment.length) {
            if (horizontalAlignment[i] < 0.0) {
                this.horizontalAbsSum += -horizontalAlignment[i];
            } else {
                this.horizontalRelSum += horizontalAlignment[i];
            }
            ++i;
        }
        this.verticalAbsSum = 0.0;
        i = 0;
        while (i < verticalAlignment.length) {
            if (verticalAlignment[i] < 0.0) {
                this.verticalAbsSum += -verticalAlignment[i];
            } else {
                this.verticalRelSum += verticalAlignment[i];
            }
            ++i;
        }
        this.locsX = horizontalAlignment.length;
        this.locsY = verticalAlignment.length;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }

    private void goToNext() {
        ++this.nextX;
        if (this.nextX >= this.locsX) {
            this.nextX = 0;
            ++this.nextY;
        }
    }

    @Override
    public void addLayoutComponent(String xyPos, Component comp) {
        if (xyPos == null) {
            this.addAtDefaultLocation(comp);
            return;
        }
        int sepPos = xyPos.indexOf(120);
        if (sepPos == -1) {
            this.addAtDefaultLocation(comp);
            return;
        }
        Loc l = new Loc();
        try {
            l.x = Integer.parseInt(xyPos.substring(0, sepPos));
            l.y = Integer.parseInt(xyPos.substring(sepPos + 1, xyPos.length()));
        }
        catch (NumberFormatException e) {
            this.addAtDefaultLocation(comp);
            return;
        }
        this.components.add(comp);
        this.locs.add(l);
        this.nextX = l.x;
        this.nextY = l.y;
        this.goToNext();
    }

    private int calcXPos(int x, int compW) {
        double res = 0.0;
        int i = 0;
        while (i < x) {
            double temp = this.horizontalAlignment[i];
            res = temp < 0.0 ? (res += -temp) : (res += ((double)compW - this.horizontalAbsSum) * temp / this.horizontalRelSum);
            ++i;
        }
        return (int)res;
    }

    private int calcYPos(int y, int compH) {
        double res = 0.0;
        int i = 0;
        while (i < y) {
            double temp = this.verticalAlignment[i];
            res = temp < 0.0 ? (res += -temp) : (res += ((double)compH - this.verticalAbsSum) * temp / this.verticalRelSum);
            ++i;
        }
        return (int)res;
    }

    private void addAtDefaultLocation(Component comp) {
        if (this.nextX < this.locsX && this.nextY < this.locsY) {
            Loc l = new Loc();
            l.x = this.nextX;
            l.y = this.nextY;
            this.components.add(comp);
            this.locs.add(l);
            this.goToNext();
        }
    }

    @Override
    public void layoutContainer(Container container) {
        int compW = container.getWidth();
        int compH = container.getHeight();
        int i = 0;
        while (i < container.getComponentCount()) {
            Component c = container.getComponent(i);
            int idx = this.components.indexOf(c);
            if (idx != -1) {
                Loc l = this.locs.get(idx);
                int x = this.calcXPos(l.x, compW);
                int y = this.calcYPos(l.y, compH);
                int w = (int)(this.horizontalAlignment[l.x] < 0.0 ? -this.horizontalAlignment[l.x] : ((double)compW - this.horizontalAbsSum) * this.horizontalAlignment[l.x] / this.horizontalRelSum);
                int h = (int)(this.verticalAlignment[l.y] < 0.0 ? -this.verticalAlignment[l.y] : ((double)compH - this.verticalAbsSum) * this.verticalAlignment[l.y] / this.verticalRelSum);
                c.setBounds(x, y, w, h);
            }
            ++i;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container myContainer) {
        return new Dimension(400, 300);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        int idx = this.components.indexOf(comp);
        this.components.remove(idx);
        this.locs.remove(idx);
    }

    private static class Loc {
        public int y;
        public int x;

        private Loc() {
        }
    }
}

