/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class BoardStyle {
    private File mapFile;
    private HashMap<String, BufferedImage> nameToImageMap = new HashMap();
    private HashMap<String, String> nameToPathMap;
    private Boolean grayImage;

    public BoardStyle(File mapFile) {
        this.mapFile = mapFile;
        try {
            this.nameToPathMap = this.readMapFile(mapFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Dimension getImageSize(String name) {
        BufferedImage img = this.getImage(name);
        if (img != null) {
            return new Dimension(img.getWidth(), img.getHeight());
        }
        return null;
    }

    private BufferedImage getImage(String name) {
        String path;
        BufferedImage img = null;
        img = this.nameToImageMap.get(name);
        if (img == null && this.mapFile != null && (path = this.nameToPathMap.get(name)) != null) {
            try {
                img = ImageIO.read(new File(this.mapFile.getParent(), path));
                this.nameToImageMap.put(name, img);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return img;
    }

    private HashMap<String, String> readMapFile(File mapFile) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader br = null;
        br = new BufferedReader(new FileReader(mapFile));
        while ((line = br.readLine()) != null) {
            int separatorPos = line.indexOf(32);
            if (separatorPos == -1) continue;
            String namePath = line.substring(0, separatorPos);
            String filePath = line.substring(separatorPos + 1);
            map.put(namePath, filePath);
        }
        return map;
    }

    public void paint(String name, int x, int y, int width, int height, Graphics g) {
        BufferedImage img = this.getImage(name);
        if (img == null) {
            if (name != null) {
                String remainder;
                int offset = 0;
                if (name.startsWith("points.", offset)) {
                    if (name.startsWith("validityPoint.", offset += "points.".length())) {
                        String remainder2 = name.substring(offset += "validityPoint.".length());
                        double r = 0.8;
                        int ow = (int)((double)width * r);
                        int oh = (int)((double)height * r);
                        int ox = x + (width - ow) >> 1;
                        int oy = y + (height - oh) >> 1;
                        if (remainder2.equals("filled")) {
                            g.setColor(Color.RED);
                            g.fillOval(ox, oy, ow, oh);
                            g.setColor(Color.BLACK);
                            g.drawOval(ox, oy, ow, oh);
                        } else if (remainder2.equals("empty")) {
                            g.setColor(Color.BLACK);
                            g.drawOval(ox, oy, ow, oh);
                        }
                    } else if (name.startsWith("treasurePoint.", offset)) {
                        String remainder3 = name.substring(offset += "treasurePoint.".length());
                        double r = 0.8;
                        int ow = (int)((double)width * r);
                        int oh = (int)((double)height * r);
                        int ox = x + (width - ow) >> 1;
                        int oy = y + (height - oh) >> 1;
                        if (remainder3.equals("filled")) {
                            g.setColor(new Color(255, 215, 0));
                            g.fillOval(ox, oy, ow, oh);
                            g.setColor(Color.BLACK);
                            g.drawOval(ox, oy, ow, oh);
                        } else if (remainder3.equals("empty")) {
                            g.setColor(Color.BLACK);
                            g.drawOval(ox, oy, ow, oh);
                        }
                    }
                } else if (name.startsWith("predictor.", offset)) {
                    String remainder4 = name.substring(offset += "predictor.".length());
                } else if (name.startsWith("doors.", offset)) {
                    String remainder5 = name.substring(offset += "doors.".length());
                    if (remainder5.equals("predictors")) {
                        g.setColor(Color.YELLOW);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    } else if (remainder5.equals("houses")) {
                        g.setColor(Color.GREEN);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    }
                } else if (name.startsWith("outcome.", offset)) {
                    String remainder6 = name.substring(offset += "outcome.".length());
                    if (remainder6.equals("spider")) {
                        g.setColor(Color.BLACK);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    } else if (remainder6.equals("treasure")) {
                        g.setColor(Color.WHITE);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    } else if (remainder6.equals("trivial")) {
                        g.setColor(Color.GRAY);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    }
                } else if (name.startsWith("feedback.", offset)) {
                    String remainder7 = name.substring(offset += "feedback.".length());
                    if (remainder7.equals("image")) {
                        g.setColor(Color.BLACK);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    } else if (remainder7.equals("trivial")) {
                        g.setColor(Color.GRAY);
                        g.drawRect(x, y, width, height);
                        g.fillRect(x, y, width, height);
                    }
                } else if (name.startsWith("break.", offset) && ((remainder = name.substring(offset += "break.".length())).equals("break") || remainder.equals("aftertrials") || remainder.equals("afterdecisions"))) {
                    g.setColor(Color.BLACK);
                    g.drawRect(x, y, width, height);
                    g.fillRect(x, y, width, height);
                }
            }
        } else if (this.getGrayImage().booleanValue()) {
            g.drawImage(BoardStyle.grayImage(img), x, y, width, height, null);
        } else {
            g.drawImage(img, x, y, width, height, null);
        }
    }

    public static BufferedImage grayImage(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int alpha = 0;
        int pix = 0;
        BufferedImage newImage = new BufferedImage(w, h, 2);
        int i = 0;
        int j = 0;
        while (i < w) {
            j = 0;
            while (j < h) {
                pix = bi.getRGB(i, j);
                alpha = pix >> 24 & 0xFF;
                int red = pix >> 16 & 0xFF;
                int green = pix >> 8 & 0xFF;
                int blue = pix & 0xFF;
                green = blue = (red + green + blue) / 3;
                red = blue;
                int newPix = alpha << 24 | red << 16 | green << 8 | blue;
                newImage.setRGB(i, j, newPix);
                ++j;
            }
            ++i;
        }
        return newImage;
    }

    public void setGrayImage(Boolean grayImage) {
        this.grayImage = grayImage;
    }

    public Boolean getGrayImage() {
        return this.grayImage;
    }

    public static BufferedImage transparentImage(BufferedImage bi, int trans) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int pix = 0;
        BufferedImage newImage = new BufferedImage(w, h, 2);
        int i = 0;
        int j = 0;
        while (i < w) {
            j = 0;
            while (j < h) {
                pix = bi.getRGB(i, j);
                int red = pix >> 16 & 0xFF;
                int green = pix >> 8 & 0xFF;
                int blue = pix & 0xFF;
                int newPix = trans << 24 | red << 16 | green << 8 | blue;
                newImage.setRGB(i, j, newPix);
                ++j;
            }
            ++i;
        }
        return newImage;
    }
}

