/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AlignGridLayout;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;
import mousekids.gui.ContinueActionEventHandler;
import mousekids.gui.SimpleComponent;

public class BreakBoard
extends Board {
    private JButton nextButton;
    private JLabel label1;
    private SimpleComponent image;
    private JPanel panel;

    public BreakBoard(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, Object nextChosen, BoardStyle boardStyle) {
        super(inqCtrl, sessionStateReflector, nextChosen, boardStyle);
        this.inqCtrl = inqCtrl;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.component = new JPanel(new AlignGridLayout(new double[]{1.0}, new double[]{0.125, 0.8, 0.075}), true);
        this.nextButton = new JButton("continue");
        this.nextButton.addActionListener(new ContinueActionEventHandler(nextChosen));
        this.label1 = new JLabel("");
        this.label1.setFont(new Font("Serif", 0, 18));
        this.label1.setVerticalTextPosition(0);
        this.label1.setHorizontalTextPosition(0);
        if (sessionStateReflector.isTrialOver()) {
            this.image = new SimpleComponent(Color.LIGHT_GRAY, boardStyle, "break.aftertrials");
        }
        if (sessionStateReflector.isBreak()) {
            this.image = new SimpleComponent(Color.LIGHT_GRAY, boardStyle, "break.break");
        }
        if (sessionStateReflector.isLastDecisionOver()) {
            this.image = new SimpleComponent(Color.LIGHT_GRAY, boardStyle, "break.afterdecisions");
        }
        this.panel.add(this.image);
        this.panel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.panel.add(this.label1);
        this.component.add("0x1", this.panel);
        this.component.add("0x2", this.nextButton);
    }
}

