/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import mousekids.gui.DoorListener;

public class DoorSlot
extends JLayeredPane {
    private static final long serialVersionUID = -3216599666302390693L;
    private JComponent leftComponent;
    private JComponent rightComponent;
    private double sliderTilePosRel;
    private double slotWidthRel;
    private JComponent sliderTile;
    private DoorListener doorListener;
    private boolean state;
    private boolean changeable;

    public DoorSlot(JComponent sliderTile, JComponent leftComp, JComponent rightComp, double slotWidthRel, boolean initState) {
        this.setLayout(null);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.sliderTile = sliderTile;
        this.slotWidthRel = slotWidthRel;
        this.leftComponent = leftComp;
        this.rightComponent = rightComp;
        if (this.leftComponent != null) {
            this.add((Component)this.leftComponent, new Integer(1));
        }
        if (this.rightComponent != null) {
            this.add((Component)this.rightComponent, new Integer(2));
        }
        this.add((Component)this.sliderTile, new Integer(3));
        SlotEvent e = new SlotEvent();
        this.addComponentListener(e);
        SliderTileEvent e2 = new SliderTileEvent();
        this.sliderTile.addMouseListener(e2);
        this.sliderTile.addMouseMotionListener(e2);
        this.initSliderTile(initState);
        this.setChangeable(true);
        this.updateSliderTile();
    }

    public JComponent getOutcomeTile() {
        return this.leftComponent;
    }

    public int getSliderTileWidth() {
        return (int)((double)this.getWidth() / this.slotWidthRel);
    }

    public int getSliderTileHeight() {
        return this.getHeight();
    }

    public int getSlotSpace() {
        return this.getWidth() - this.getSliderTileWidth();
    }

    public void updateSlot() {
        if (this.leftComponent != null) {
            this.leftComponent.setBounds(0, 0, this.getSliderTileWidth(), this.getSliderTileHeight());
        }
        if (this.rightComponent != null) {
            this.rightComponent.setBounds(this.getWidth() - this.getSliderTileWidth(), 0, this.getSliderTileWidth(), this.getSliderTileHeight());
        }
    }

    public void updateSliderTile() {
        this.sliderTile.setSize(this.getSliderTileWidth(), this.getSliderTileHeight());
        this.updateSliderTilePos();
    }

    private void initSliderTile(boolean initState) {
        this.sliderTilePosRel = initState ? 1.0 : 0.0;
        this.sliderTile.setLocation((int)((double)this.getSlotSpace() * this.sliderTilePosRel), 0);
        this.state = initState;
    }

    public void updateSliderTilePos() {
        boolean newState;
        this.sliderTile.setLocation((int)((double)this.getSlotSpace() * this.sliderTilePosRel), 0);
        boolean bl = newState = this.sliderTilePosRel >= 0.1;
        if (newState != this.state) {
            this.state = newState;
            if (this.state) {
                if (this.doorListener != null) {
                    this.doorListener.doorOpened(this);
                }
            } else if (this.doorListener != null) {
                this.doorListener.doorClosed(this);
            }
        }
    }

    public void setSliderTilePos(double rel) {
        this.sliderTilePosRel = rel;
        this.updateSliderTilePos();
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean isOpen) {
        if (isOpen) {
            this.setSliderTilePos(1.0);
        } else {
            this.setSliderTilePos(0.0);
        }
        this.state = isOpen;
    }

    public void setStateObvious() {
        this.setState(this.state);
    }

    public void setDoorListener(DoorListener doorListener) {
        this.doorListener = doorListener;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.gray);
        g.fillRect(0, 0, (int)((double)this.getWidth() * this.slotWidthRel), this.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, (int)((double)this.getWidth() * this.slotWidthRel), this.getHeight());
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean changeable) {
        this.changeable = changeable;
    }

    private class SliderTileEvent
    extends MouseAdapter {
        private int oldX;
        private boolean draggingAborted = false;

        private SliderTileEvent() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.oldX = e.getX();
            if (DoorSlot.this.doorListener != null) {
                DoorSlot.this.doorListener.doorPressed(DoorSlot.this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DoorSlot.this.changeable && !this.draggingAborted) {
                int eX = e.getX();
                int eY = e.getY();
                int newX = DoorSlot.this.sliderTile.getX() + eX - this.oldX;
                newX = Math.max(0, Math.min(newX, DoorSlot.this.getWidth() - DoorSlot.this.getSliderTileWidth()));
                DoorSlot.this.setSliderTilePos((double)newX / (double)DoorSlot.this.getSlotSpace());
                if (DoorSlot.this.doorListener != null) {
                    DoorSlot.this.doorListener.doorDragged(DoorSlot.this);
                }
                int slotX = eX + newX;
                int slotY = eY;
                if (slotX < 0 || slotX > DoorSlot.this.getWidth() || slotY < 0 || slotY > DoorSlot.this.getHeight()) {
                    this.draggingAborted = true;
                    if (DoorSlot.this.doorListener != null) {
                        DoorSlot.this.doorListener.doorDraggingAborted(DoorSlot.this);
                        DoorSlot.this.doorListener.doorActionTerminated(DoorSlot.this);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.draggingAborted && DoorSlot.this.doorListener != null) {
                DoorSlot.this.doorListener.doorReleased(DoorSlot.this);
                DoorSlot.this.doorListener.doorActionTerminated(DoorSlot.this);
            }
            this.draggingAborted = false;
        }
    }

    private class SlotEvent
    extends MouseAdapter
    implements ComponentListener {
        private SlotEvent() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DoorSlot.this.updateSliderTile();
            DoorSlot.this.updateSlot();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

