/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AlignGridLayout;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;
import mousekids.gui.ContinueActionEventHandler;

public class InitBoard
extends Board {
    private InquiryUserController inqCtrl;
    private JButton nextButton;
    private JPanel midPanel;
    private JLabel vlLabel;
    private JLabel vpnLabel;
    private JTextField vlText;
    private JTextField vpnText;

    public InitBoard(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, Object nextChosen, BoardStyle boardStyle) {
        super(inqCtrl, sessionStateReflector, nextChosen, boardStyle);
        this.inqCtrl = inqCtrl;
        this.vlLabel = new JLabel("VL");
        this.vpnLabel = new JLabel("VPN");
        this.vlText = new JTextField();
        this.vpnText = new JTextField();
        this.vlText.setToolTipText("Please insert the VL before using the Next-Button");
        this.vpnText.setToolTipText("Please insert the VPN before using the Next-Button");
        this.midPanel = new JPanel(new AlignGridLayout(new double[]{0.4, 0.1, 0.1, 0.4}, new double[]{0.4, 0.1, 0.1, 0.4}), true);
        this.midPanel.add("1x1", this.vlLabel);
        this.midPanel.add("1x2", this.vpnLabel);
        this.midPanel.add("2x1", this.vlText);
        this.midPanel.add("2x2", this.vpnText);
        this.nextButton = new JButton("continue");
        this.nextButton.addActionListener(new ContinueActionEventHandler(nextChosen, this));
        this.component = new JPanel(new AlignGridLayout(new double[]{1.0}, new double[]{0.125, 0.8, 0.075}), true);
        this.component.add("0x1", this.midPanel);
        this.component.add("0x2", this.nextButton);
        this.updateNextButton();
    }

    private void updateNextButton() {
        this.nextButton.setVisible(this.sessionStateReflector.isNextable());
    }

    public void readInsert() {
        this.inqCtrl.setVL(this.vlText.getText());
        this.inqCtrl.setVPN(this.vpnText.getText());
    }
}

