/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mousekids.core.Inquiry;
import mousekids.core.InquiryController;
import mousekids.core.InquiryFile;
import mousekids.core.InquiryFileIO;
import mousekids.core.InquiryProcess;
import mousekids.core.InquiryUserActionController;
import mousekids.core.InquiryUserControllerLogger;
import mousekids.core.MousekidsProtocolException;
import mousekids.core.SimpleSessionStateReflector;
import mousekids.gui.BoardStyle;
import mousekids.gui.ManagerP;
import mousekids.test.InquiryUserControllerConsoleOutput;

public class ManagerIPO {
    private static final FileFilter fileFilterMKP = new FileFilter(){

        @Override
        public String getDescription() {
            return "Mousekids-Files";
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.isFile() && f.getName().toLowerCase().endsWith(".mkp");
        }
    };

    public File enterInputFile() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(fileFilterMKP);
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Eingabedatei \u00f6ffnen ...");
        fc.setFileFilter(fileFilterMKP);
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(null);
        return fc.getSelectedFile();
    }

    public File enterOutputFile() {
        File selFile;
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(fileFilterMKP);
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Ausgabedatei speichern unter ...");
        fc.setFileFilter(fileFilterMKP);
        fc.setMultiSelectionEnabled(false);
        boolean ok = true;
        do {
            fc.showSaveDialog(null);
            selFile = fc.getSelectedFile();
            if (!selFile.exists()) continue;
            boolean bl = ok = JOptionPane.showConfirmDialog(null, "Die Datei \"" + selFile.getName() + "\" existiert bereits. \u00dcberschreiben?", "Datei \u00fcberschreiben", 0, 2) == 0;
        } while (!ok);
        return selFile;
    }

    public File enterImageMapFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Bildzuordnungsdatei \u00f6ffnen ...");
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(null);
        return fc.getSelectedFile();
    }

    public void start() {
        File inFile = this.getInFile();
        InquiryFile inqFile = this.createInquiryFile(inFile);
        Inquiry inquiry = this.createInquiry(inqFile);
        File outFile = this.getOutFile();
        InquiryController inqCtrl = new InquiryController(inquiry);
        InquiryUserControllerLogger inqUCL = new InquiryUserControllerLogger(inquiry.getProcess());
        inqUCL.resetLog();
        inqCtrl.addUserControllerListener(inqUCL);
        inqCtrl.addUserControllerListener(new InquiryUserControllerConsoleOutput(System.out));
        SimpleSessionStateReflector sssr = new SimpleSessionStateReflector(inquiry, inqCtrl.getSessionState());
        InquiryUserActionController inqCtrl2 = new InquiryUserActionController(inqCtrl, sssr);
        File mapFile = this.enterImageMapFile();
        BoardStyle style = new BoardStyle(mapFile);
        ManagerP managerP = new ManagerP(inqCtrl2, sssr, style);
        switch (managerP.start()) {
            case 0: {
                break;
            }
            case 1: {
                inqUCL.logInterrupted();
            }
        }
        this.rewriteProcess(inquiry.getProcess(), inqFile);
        try {
            this.writeInquiryFile(outFile, inqFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MousekidsProtocolException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void writeInquiryFile(File outFile, InquiryFile inqFile) throws IOException, MousekidsProtocolException {
        System.out.println("OutputFile has been written.");
        InquiryFileIO.writeInquiryFile(inqFile, new BufferedWriter(new FileWriter(outFile)), 1);
    }

    private void rewriteProcess(InquiryProcess process, InquiryFile inqFile) {
        InquiryFileIO.rewriteInquiryFileSection(inqFile, InquiryFileIO.createProcessFileSection(process));
    }

    private File getOutFile() {
        File outFile = this.enterOutputFile();
        return outFile;
    }

    private Inquiry createInquiry(InquiryFile inqFile) {
        Inquiry inquiry = null;
        try {
            inquiry = InquiryFileIO.createInquiry(inqFile);
        }
        catch (MousekidsProtocolException e) {
            e.printStackTrace();
        }
        return inquiry;
    }

    private InquiryFile createInquiryFile(File inFile) {
        InquiryFile inqFile = null;
        try {
            inqFile = InquiryFileIO.readInquiryFile(new BufferedReader(new FileReader(inFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MousekidsProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inqFile;
    }

    private File getInFile() {
        File inFile = this.enterInputFile();
        return inFile;
    }
}

