/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jxl.write.WriteException;
import mousekids.core.Inquiry;
import mousekids.core.InquiryFile;
import mousekids.core.InquiryFileIO;
import mousekids.core.MousekidsProtocolException;
import mousekids.core.WriteExcel;

public class ManagerIPO_Translator {
    private static final FilenameFilter fileFilterMKP = new FilenameFilter(){

        @Override
        public boolean accept(File f, String name) {
            return name.toLowerCase().endsWith(".mkp");
        }
    };

    public File enterInputFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Choose Directory with InputFiles");
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(null);
        return fc.getSelectedFile();
    }

    public File enterOutputFile() {
        File selFile;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("OutputFile save as");
        fc.setMultiSelectionEnabled(false);
        boolean ok = true;
        do {
            fc.showSaveDialog(null);
            selFile = fc.getSelectedFile();
            if (!selFile.exists()) continue;
            boolean bl = ok = JOptionPane.showConfirmDialog(null, "The File \"" + selFile.getName() + "\" does already exist. To overwrite?", "Overwritting File", 0, 2) == 0;
        } while (!ok);
        return selFile;
    }

    public void start() throws IOException, WriteException {
        File[] inFile = this.getInFiles();
        ArrayList<Inquiry> inquiry = new ArrayList<Inquiry>(inFile.length);
        ArrayList<String> excludedFiles = new ArrayList<String>();
        File outFile = this.getOutFile();
        WriteExcel we = new WriteExcel(outFile);
        int j = 0;
        int i = 0;
        while (i < inFile.length) {
            InquiryFile inqFile = this.createInquiryFile(inFile[i]);
            inquiry.add(this.createInquiry(inqFile));
            if (i > 0 && (((Inquiry)inquiry.get(i - j)).getSettings().getRowCount() != ((Inquiry)inquiry.get(i - 1 - j)).getSettings().getRowCount() || ((Inquiry)inquiry.get(i - j)).getSettings().getColumnCount() != ((Inquiry)inquiry.get(i - 1 - j)).getSettings().getColumnCount() || ((Inquiry)inquiry.get(i - j)).getSettings().getNumberOfLearningBoards() != ((Inquiry)inquiry.get(i - 1 - j)).getSettings().getNumberOfLearningBoards() || ((Inquiry)inquiry.get(i - j)).getSettings().getNumberOfDecisionBoards() != ((Inquiry)inquiry.get(i - 1 - j)).getSettings().getNumberOfDecisionBoards())) {
                inquiry.remove(inquiry.get(i - j));
                excludedFiles.add(inFile[i].getName());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < inquiry.size()) {
            ((Inquiry)inquiry.get(i)).getProcess().extractDataInquiryProcess(((Inquiry)inquiry.get(i)).getSettings().getRowCount(), ((Inquiry)inquiry.get(i)).getSettings().getColumnCount());
            this.createExcelFile((Inquiry)inquiry.get(i), i, we);
            ++i;
        }
        we.write();
        if (excludedFiles.size() == 0) {
            JOptionPane.showMessageDialog(null, "All MouseKidsProtocols were processed successfully", "Completed", 1);
        } else {
            String m = new String("The following Files have been excluded:\n");
            int i2 = 0;
            while (i2 < excludedFiles.size()) {
                m = String.valueOf(m) + " " + (String)excludedFiles.get(i2) + "\n";
                ++i2;
            }
            JOptionPane.showMessageDialog(null, m, "Warning", 2);
        }
        System.exit(0);
    }

    private void createExcelFile(Inquiry inquiry, int n, WriteExcel we) throws WriteException, IOException {
        we.create(inquiry, n);
    }

    private Inquiry createInquiry(InquiryFile inqFile) {
        Inquiry inquiry = null;
        try {
            inquiry = InquiryFileIO.createInquiry(inqFile);
        }
        catch (MousekidsProtocolException e) {
            e.printStackTrace();
        }
        return inquiry;
    }

    private InquiryFile createInquiryFile(File inFile) {
        InquiryFile inqFile = null;
        try {
            inqFile = InquiryFileIO.readInquiryFile(new BufferedReader(new FileReader(inFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MousekidsProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inqFile;
    }

    private File getOutFile() {
        File outFile = this.enterOutputFile();
        return outFile;
    }

    private File[] getInFiles() {
        return this.enterInputFile().listFiles(fileFilterMKP);
    }
}

