/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AfterLearningPhaseBoard;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;
import mousekids.gui.BreakBoard;
import mousekids.gui.FeedbackBoard;
import mousekids.gui.InitBoard;
import mousekids.gui.MatrixBoard;
import mousekids.gui.RatioKeepingLayout;
import mousekids.gui.SelectionBoard;
import mousekids.gui.TerminatedBoard;

public class ManagerP {
    private InquiryUserController inqCtrl;
    private SessionStateReflector sessionStateReflector;
    private JFrame frame;
    private BoardStyle boardStyle;
    private boolean windowClosed = false;
    private Object nextChosen;
    public static final int NORMAL_EXIT = 0;
    public static final int INTERRUPTED = 1;

    public ManagerP(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, BoardStyle style) {
        this.inqCtrl = inqCtrl;
        this.sessionStateReflector = sessionStateReflector;
        this.boardStyle = style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() {
        this.frame = new JFrame("Mousekids");
        this.frame.setVisible(true);
        if (this.sessionStateReflector.isTouchScreen()) {
            this.frame.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 6), new Point(0, 0), "NOCURSOR"));
        }
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.frame);
        this.nextChosen = new Object();
        JComponent comp = null;
        Board board = null;
        boolean terminated = false;
        JPanel ratioKeeper = new JPanel(new RatioKeepingLayout(1.3333333333333333), true);
        ratioKeeper.setBackground(Color.BLACK);
        this.frame.add(ratioKeeper);
        this.frame.setExtendedState(6);
        this.frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent evt) {
                ManagerP.this.windowClosed = true;
                Object object = ManagerP.this.nextChosen;
                synchronized (object) {
                    ManagerP.this.nextChosen.notify();
                }
            }
        });
        do {
            switch (this.sessionStateReflector.getBoardToDisplay()) {
                case 0: {
                    board = new InitBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case 1: {
                    board = new SelectionBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case 2: {
                    board = new MatrixBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case 3: {
                    board = new AfterLearningPhaseBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case 5: {
                    board = new BreakBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case 4: {
                    board = new FeedbackBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    break;
                }
                case -1: {
                    board = new TerminatedBoard(this.inqCtrl, this.sessionStateReflector, this.nextChosen, this.boardStyle);
                    terminated = true;
                }
            }
            if (board != null && (comp = board.getComponent()) != null) {
                ratioKeeper.add(comp);
                ratioKeeper.validate();
                do {
                    try {
                        Object object = this.nextChosen;
                        synchronized (object) {
                            this.nextChosen.wait();
                        }
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                } while (!this.sessionStateReflector.isNextable() && !this.windowClosed);
                if (!this.windowClosed) {
                    ratioKeeper.remove(comp);
                }
            }
            if (this.windowClosed) continue;
            this.inqCtrl.next();
        } while (!terminated && !this.windowClosed);
        return this.windowClosed ? 1 : 0;
    }
}

