/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AlignGridLayout;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;
import mousekids.gui.ContinueActionEventHandler;
import mousekids.gui.DoorListener;
import mousekids.gui.DoorSlot;
import mousekids.gui.RatioKeepingLayout;
import mousekids.gui.SimpleComponent;

public class MatrixBoard
extends Board {
    private JButton nextButton;
    private boolean interactionsBlocked = false;
    DoorSlot[][] dsArray;

    public MatrixBoard(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, Object nextChosen, BoardStyle boardStyle) {
        super(inqCtrl, sessionStateReflector, nextChosen, boardStyle);
        int width = 1 + sessionStateReflector.getNumberOfDecisionBoards() + 1 - sessionStateReflector.getNumberOfTrials();
        int height = 2;
        double[] horizontalAlignment = new double[1];
        int i = 0;
        while (i < horizontalAlignment.length) {
            horizontalAlignment[i] = 1.0;
            ++i;
        }
        JPanel treasureShelf = new JPanel();
        treasureShelf.setLayout(new BoxLayout(treasureShelf, 0));
        double[] verticalAlignment = new double[height];
        int i2 = 0;
        while (i2 < verticalAlignment.length) {
            verticalAlignment[i2] = 1.0;
            ++i2;
        }
        JPanel treasurePointsPanel = new JPanel(new AlignGridLayout(horizontalAlignment, verticalAlignment), true);
        if (sessionStateReflector.isTreasurePointVisible()) {
            int i3 = 0;
            while (i3 < sessionStateReflector.getNumberOfDecisionBoards() - sessionStateReflector.getNumberOfTrials()) {
                TreasurePoint tp = i3 < sessionStateReflector.getNumberOfVisibleTreasurePoints() ? new TreasurePoint(true, false, boardStyle) : (i3 > sessionStateReflector.getNumberOfVisibleTreasurePoints() ? new TreasurePoint(false, false, boardStyle) : new TreasurePoint(false, true, boardStyle));
                treasureShelf.add(tp);
                ++i3;
            }
        }
        JPanel interTreasure = new JPanel(new RatioKeepingLayout(sessionStateReflector.getNumberOfDecisionBoards() - sessionStateReflector.getNumberOfTrials()));
        interTreasure.add(treasureShelf);
        treasurePointsPanel.add("0x1", interTreasure);
        width = 4 + 2 * sessionStateReflector.getNumberOfHouses() + 1;
        height = 1 + 2 * (sessionStateReflector.getNumberOfSelectablePredictors() + 1);
        horizontalAlignment = new double[width];
        int i4 = 0;
        while (i4 < horizontalAlignment.length) {
            horizontalAlignment[i4] = 1.0;
            ++i4;
        }
        i4 = 0;
        while (i4 < sessionStateReflector.getNumberOfHouses()) {
            horizontalAlignment[5 + 2 * i4] = 2.0;
            horizontalAlignment[4 + 2 * i4] = 0.75;
            ++i4;
        }
        double hasum = 0.0;
        int i5 = 0;
        while (i5 < horizontalAlignment.length) {
            hasum += horizontalAlignment[i5];
            ++i5;
        }
        horizontalAlignment[1] = hasum / 3.0;
        verticalAlignment = new double[height];
        i5 = 0;
        while (i5 < verticalAlignment.length) {
            verticalAlignment[i5] = 1.0;
            ++i5;
        }
        i5 = 0;
        while (i5 < sessionStateReflector.getNumberOfSelectablePredictors()) {
            verticalAlignment[2 + 2 * i5] = 0.25;
            ++i5;
        }
        verticalAlignment[0] = 0.5;
        verticalAlignment[verticalAlignment.length - 1] = 0.0625;
        JPanel matrixPanel = new JPanel(new AlignGridLayout(horizontalAlignment, verticalAlignment), true);
        this.dsArray = new DoorSlot[sessionStateReflector.getNumberOfSelectablePredictors() + 1][sessionStateReflector.getNumberOfHouses()];
        int row = 0;
        while (row <= sessionStateReflector.getNumberOfSelectablePredictors()) {
            JPanel rkp;
            if (row > 0) {
                JPanel validityShelf = new JPanel();
                validityShelf.setLayout(new BoxLayout(validityShelf, 0));
                int i6 = 0;
                while (i6 < sessionStateReflector.getNumberOfLearningBoards()) {
                    ValidityPoint vp = i6 < sessionStateReflector.getNumberOfValidityPoints(row) ? new ValidityPoint(row, true, false, boardStyle) : (i6 > sessionStateReflector.getNumberOfValidityPoints(row) ? new ValidityPoint(row, false, false, boardStyle) : new ValidityPoint(row, false, true, boardStyle));
                    validityShelf.add(vp);
                    ++i6;
                }
                JPanel interValidity = new JPanel(new RatioKeepingLayout(sessionStateReflector.getNumberOfLearningBoards()));
                interValidity.add(validityShelf);
                matrixPanel.add("1x" + (1 + 2 * row), interValidity);
                SimpleComponent psc = new SimpleComponent(Color.WHITE, boardStyle, "predictor." + sessionStateReflector.getMatrixPredictor(row));
                if (sessionStateReflector.getLearningPhaseCurrentPredictor() == row || sessionStateReflector.getLearningPhaseCurrentPredictor() == -1) {
                    psc.setBorder(BorderFactory.createBevelBorder(0));
                } else {
                    psc.setBorder(BorderFactory.createBevelBorder(1));
                    psc.setGrayImage(true);
                }
                rkp = new JPanel(new RatioKeepingLayout(1.0));
                rkp.add(psc);
                matrixPanel.add("3x" + (1 + 2 * row), rkp);
            }
            if (sessionStateReflector.getQuestionnarePhaseCurrentQuestionnare() != -1) {
                SimpleComponent qsc = new SimpleComponent(Color.WHITE, boardStyle, "questionnare." + sessionStateReflector.getMatrixQuestionnare(sessionStateReflector.getQuestionnarePhaseCurrentQuestionnare()));
                rkp = new JPanel(new RatioKeepingLayout(1.0));
                rkp.add(qsc);
                matrixPanel.add("3x1", rkp);
            }
            int col = 0;
            while (col < sessionStateReflector.getNumberOfDoorColumns(row)) {
                JToggleButton toggleButton = sessionStateReflector.isOutcomeTrivial(row, col) ? new JToggleButton("?", true) : (sessionStateReflector.isTreasureHere(row, col) ? new JToggleButton("Treasure", true) : new JToggleButton("Spider", true));
                toggleButton.setSelected(sessionStateReflector.isDoorOpen(row, col));
                toggleButton.addActionListener(new DoorActionEventHandler(row, col, sessionStateReflector.isDoorOpen(row, col)));
                SimpleComponent lc = new SimpleComponent(Color.WHITE, boardStyle, "outcome." + (sessionStateReflector.isOutcomeTrivial(row, col) ? "trivial" : (sessionStateReflector.isTreasureHere(row, col) ? "treasure" : "spider")));
                String imgName = "doors." + (row == 0 ? "houses" : "predictors");
                SimpleComponent sc = new SimpleComponent(Color.WHITE, boardStyle, imgName);
                sc.setBorder(BorderFactory.createBevelBorder(0));
                DoorSlot ds = new DoorSlot(sc, lc, null, 2.0, sessionStateReflector.isDoorOpen(row, col));
                ds.setDoorListener(new WonderfulDoorListener(row, col));
                this.dsArray[row][col] = ds;
                JPanel dc = new JPanel(new RatioKeepingLayout(2.0), true);
                dc.add(ds);
                matrixPanel.add(String.valueOf(5 + 2 * col) + "x" + (1 + 2 * row), dc);
                ++col;
            }
            ++row;
        }
        this.nextButton = new JButton("continue");
        this.nextButton.addActionListener(new ContinueActionEventHandler(nextChosen));
        this.component = new JPanel(new AlignGridLayout(new double[]{1.0}, new double[]{0.125, 0.8, 0.075}), true);
        this.component.add("0x0", treasurePointsPanel);
        this.component.add("0x1", matrixPanel);
        this.component.add("0x2", this.nextButton);
        this.updateNextButton();
    }

    private void updateNextButton() {
        if (this.sessionStateReflector.isPredictorOver()) {
            this.nextButton.setBackground(Color.LIGHT_GRAY);
            if (this.sessionStateReflector.isInstructionManual()) {
                this.nextButton.setText("Please go back to the instruction manual!");
            }
            this.nextButton.repaint();
        }
        this.nextButton.setVisible(this.sessionStateReflector.isNextable());
    }

    private void updateDoorSlots() {
        int row = 0;
        while (row <= this.sessionStateReflector.getNumberOfSelectablePredictors()) {
            int col = 0;
            while (col < this.sessionStateReflector.getNumberOfDoorColumns(row)) {
                this.dsArray[row][col].setState(this.sessionStateReflector.isDoorOpen(row, col));
                ++col;
            }
            ++row;
        }
    }

    private class DoorActionEventHandler
    implements ActionListener,
    Runnable {
        int row;
        int column;
        boolean toggleState;
        JToggleButton tb;
        SessionStateReflector sessionStateReflector;

        public DoorActionEventHandler(int row, int column, boolean initToggleState) {
            this.toggleState = initToggleState;
            this.row = row;
            this.column = column;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean nothingDone = false;
            this.tb = (JToggleButton)e.getSource();
            if (!MatrixBoard.this.interactionsBlocked) {
                if (this.sessionStateReflector.isDoorChangeable(this.row, this.column)) {
                    this.toggleState ^= true;
                    if (this.sessionStateReflector.isOutcomeTrivial(this.row, this.column)) {
                        this.tb.setText("?");
                    } else if (this.sessionStateReflector.isTreasureHere(this.row, this.column)) {
                        this.tb.setText("Treasure");
                    } else {
                        this.tb.setText("Spider");
                    }
                    Thread opening = new Thread(this);
                    MatrixBoard.this.interactionsBlocked = true;
                    opening.start();
                } else {
                    nothingDone = true;
                }
            } else {
                nothingDone = true;
            }
            if (nothingDone) {
                this.tb.setSelected(!this.tb.isSelected());
                MatrixBoard.this.updateNextButton();
            }
        }

        @Override
        public void run() {
            MatrixBoard.this.inqCtrl.setDoor(this.row, this.column, this.toggleState);
            this.toggleState = this.sessionStateReflector.isDoorOpen(this.row, this.column);
            this.tb.setSelected(this.toggleState);
            MatrixBoard.this.updateNextButton();
            MatrixBoard.this.interactionsBlocked = false;
        }
    }

    public class TreasurePoint
    extends JComponent {
        private static final long serialVersionUID = -7585798814016957032L;
        private BoardStyle style;
        private boolean state;
        private boolean enabled;

        public TreasurePoint(boolean initState, boolean enabled, BoardStyle style) {
            this.style = style;
            this.state = initState;
            this.enabled = enabled;
            this.addMouseListener(new ValidityPointActionEventHandler());
        }

        public void setState(boolean s) {
            this.state = s;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.style.paint("points.treasurePoint." + (this.state ? "filled" : "empty"), 0, 0, this.getWidth(), this.getHeight(), g);
        }

        private class ValidityPointActionEventHandler
        extends MouseAdapter {
            private ValidityPointActionEventHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (TreasurePoint.this.enabled) {
                    if (((TreasurePoint)TreasurePoint.this).MatrixBoard.this.sessionStateReflector.isTreasurePointSettable()) {
                        TreasurePoint treasurePoint = TreasurePoint.this;
                        treasurePoint.state = treasurePoint.state ^ true;
                        ((TreasurePoint)TreasurePoint.this).MatrixBoard.this.inqCtrl.addVisibleTreasurePoint(TreasurePoint.this.state ? 1 : -1);
                        TreasurePoint.this.repaint();
                    }
                    MatrixBoard.this.updateNextButton();
                }
            }
        }
    }

    public class ValidityPoint
    extends JComponent {
        private static final long serialVersionUID = -4737056943703784228L;
        private BoardStyle style;
        private boolean state;
        private int row;
        private boolean enabled;

        public ValidityPoint(int row, boolean initState, boolean enabled, BoardStyle style) {
            this.style = style;
            this.state = initState;
            this.row = row;
            this.enabled = enabled;
            this.addMouseListener(new ValidityPointActionEventHandler());
        }

        public void setState(boolean s) {
            this.state = s;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.style.paint("points.validityPoint." + (this.state ? "filled" : "empty"), 0, 0, this.getWidth(), this.getHeight(), g);
        }

        private class ValidityPointActionEventHandler
        extends MouseAdapter {
            private ValidityPointActionEventHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ValidityPoint.this.enabled) {
                    if (((ValidityPoint)ValidityPoint.this).MatrixBoard.this.sessionStateReflector.isValidityPointSettable(ValidityPoint.this.row)) {
                        ValidityPoint validityPoint = ValidityPoint.this;
                        validityPoint.state = validityPoint.state ^ true;
                        ((ValidityPoint)ValidityPoint.this).MatrixBoard.this.inqCtrl.addValidityPoint(ValidityPoint.this.row, ValidityPoint.this.state ? 1 : -1);
                        ValidityPoint.this.repaint();
                    }
                    MatrixBoard.this.updateNextButton();
                }
            }
        }
    }

    private class WonderfulDoorListener
    implements DoorListener {
        int visibleRow;
        int column;

        public WonderfulDoorListener(int visibleRow, int column) {
            this.visibleRow = visibleRow;
            this.column = column;
        }

        @Override
        public void doorPressed(DoorSlot doorSlot) {
            doorSlot.setChangeable(MatrixBoard.this.sessionStateReflector.isDoorChangeable(this.visibleRow, this.column));
        }

        @Override
        public void doorDragged(DoorSlot ds) {
        }

        @Override
        public void doorDraggingAborted(DoorSlot ds) {
        }

        @Override
        public void doorOpened(DoorSlot ds) {
            Thread opening = new Thread(new RunningDoor(true, ds));
            opening.start();
        }

        @Override
        public void doorClosed(DoorSlot ds) {
            Thread opening = new Thread(new RunningDoor(false, ds));
            opening.start();
        }

        @Override
        public void doorReleased(DoorSlot ds) {
        }

        @Override
        public void doorActionTerminated(DoorSlot ds) {
            ds.setState(MatrixBoard.this.sessionStateReflector.isDoorOpen(this.visibleRow, this.column));
            MatrixBoard.this.updateNextButton();
            MatrixBoard.this.updateDoorSlots();
        }

        private class RunningDoor
        implements Runnable {
            boolean state;
            DoorSlot doorSlot;

            public RunningDoor(boolean state, DoorSlot doorSlot) {
                this.state = state;
                this.doorSlot = doorSlot;
            }

            @Override
            public void run() {
                ((WonderfulDoorListener)WonderfulDoorListener.this).MatrixBoard.this.inqCtrl.setDoor(WonderfulDoorListener.this.visibleRow, WonderfulDoorListener.this.column, this.state);
                this.doorSlot.setState(((WonderfulDoorListener)WonderfulDoorListener.this).MatrixBoard.this.sessionStateReflector.isDoorOpen(WonderfulDoorListener.this.visibleRow, WonderfulDoorListener.this.column));
                if (((WonderfulDoorListener)WonderfulDoorListener.this).MatrixBoard.this.sessionStateReflector.isHighlightOption()) {
                    this.doorSlot.getOutcomeTile().setBorder(new BevelBorder(0, Color.MAGENTA, Color.CYAN));
                }
                MatrixBoard.this.updateNextButton();
                MatrixBoard.this.updateDoorSlots();
            }
        }
    }
}

