/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RatioKeepingComponent
extends JPanel {
    private static final long serialVersionUID = 4260007466949701373L;
    protected double ratio;
    protected JComponent innerComponent;
    protected Color borderColor;
    protected SizeKeepingComponent borderNorth;
    protected SizeKeepingComponent borderSouth;
    protected SizeKeepingComponent borderEast;
    protected SizeKeepingComponent borderWest;

    public RatioKeepingComponent(double ratio, JComponent innerComponent, Color borderColor) {
        this.ratio = ratio;
        this.innerComponent = innerComponent;
        this.borderColor = borderColor;
        this.setLayout(new BorderLayout());
        this.borderNorth = new SizeKeepingComponent(0, 0);
        this.add((Component)this.borderNorth, "North");
        this.borderSouth = new SizeKeepingComponent(0, 0);
        this.add((Component)this.borderSouth, "South");
        this.borderEast = new SizeKeepingComponent(0, 0);
        this.add((Component)this.borderEast, "East");
        this.borderWest = new SizeKeepingComponent(0, 0);
        this.add((Component)this.borderWest, "West");
        this.setInnerComponent(innerComponent);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
                RatioKeepingComponent.this.updateSizes();
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                RatioKeepingComponent.this.updateSizes();
                System.out.println(String.valueOf(RatioKeepingComponent.this.getWidth()) + ", " + RatioKeepingComponent.this.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
                RatioKeepingComponent.this.updateSizes();
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
    }

    public void updateSizes() {
        if (this.innerComponent != null) {
            int h;
            int w = this.getWidth();
            double r = (double)w / (double)(h = this.getHeight());
            if (r < this.ratio) {
                int newInnerWidth = w;
                int newInnerHeight = (int)((double)newInnerWidth / this.ratio);
                int oneSpace = h - newInnerHeight >> 1;
                this.innerComponent.setBounds(0, oneSpace, newInnerWidth, newInnerHeight);
                this.borderNorth.setKeepingSize(newInnerWidth, oneSpace);
                this.borderSouth.setKeepingSize(newInnerWidth, h - newInnerHeight - oneSpace);
                this.borderEast.setKeepingSize(0, newInnerHeight);
                this.borderWest.setKeepingSize(0, newInnerHeight);
            } else {
                int newInnerHeight = h;
                int newInnerWidth = (int)((double)newInnerHeight * this.ratio);
                int oneSpace = w - newInnerWidth >> 1;
                this.innerComponent.setBounds(oneSpace, 0, newInnerWidth, newInnerHeight);
                this.borderNorth.setKeepingSize(w, 0);
                this.borderSouth.setKeepingSize(w, 0);
                this.borderEast.setKeepingSize(w - newInnerWidth - oneSpace, newInnerHeight);
                this.borderWest.setKeepingSize(oneSpace, newInnerHeight);
            }
        }
        System.out.println(this.borderSouth.getSize());
        this.repaint();
    }

    public void setInnerComponent(JComponent comp) {
        if (this.innerComponent != null) {
            this.remove(this.innerComponent);
        }
        this.innerComponent = comp;
        if (this.innerComponent != null) {
            this.add(this.innerComponent);
        }
    }

    private class SizeKeepingComponent
    extends JComponent
    implements ComponentListener {
        private static final long serialVersionUID = 676570252623221532L;
        protected int keepingWidth;
        protected int keepingHeight;

        public SizeKeepingComponent(int keepingWidth, int keepingHeight) {
            this.keepingWidth = keepingWidth;
            this.keepingHeight = keepingHeight;
        }

        public void setKeepingWidth(int keepingWidth) {
            this.keepingWidth = keepingWidth;
        }

        public void setKeepingHeight(int keepingHeight) {
            this.keepingHeight = keepingHeight;
        }

        public void setKeepingSize(int keepingWidth, int keepingHeight) {
            this.setKeepingWidth(keepingWidth);
            this.setKeepingHeight(keepingHeight);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.keepingWidth, this.keepingHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(RatioKeepingComponent.this.borderColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            System.out.println("X " + this.getWidth() + ", " + this.getHeight());
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

