/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

public class RatioKeepingLayout
implements LayoutManager2 {
    private double ratio;
    private Component component;

    public RatioKeepingLayout() {
        this(1.0);
    }

    public RatioKeepingLayout(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public void addLayoutComponent(String xyPos, Component comp) {
        if (this.component == null) {
            this.component = comp;
            this.component.repaint();
        }
    }

    @Override
    public void layoutContainer(Container container) {
        int contW = container.getWidth();
        int contH = container.getHeight();
        int cc = container.getComponentCount();
        int i = 0;
        while (i < cc) {
            Component c = container.getComponent(i);
            if (c == this.component && c.isVisible()) {
                int h;
                int w;
                int y;
                int x;
                double inner;
                if ((double)contW / (double)contH < this.ratio) {
                    inner = (double)contW / this.ratio;
                    x = 0;
                    y = (int)(((double)contH - inner) * 0.5);
                    w = contW;
                    h = (int)inner;
                } else {
                    inner = (double)contH * this.ratio;
                    x = (int)(((double)contW - inner) * 0.5);
                    y = 0;
                    w = (int)inner;
                    h = contH;
                }
                c.setBounds(x, y, w, h);
            }
            ++i;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container myContainer) {
        return myContainer.getSize();
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this.component) {
            this.component = null;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object arg1) {
        this.addLayoutComponent("", comp);
    }

    @Override
    public float getLayoutAlignmentX(Container arg0) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container arg0) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container arg0) {
    }

    @Override
    public Dimension maximumLayoutSize(Container arg0) {
        return null;
    }
}

