/*
 * Decompiled with CFR 0.152.
 */
package mousekids.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import mousekids.core.InquiryUserController;
import mousekids.core.SessionStateReflector;
import mousekids.gui.AlignGridLayout;
import mousekids.gui.Board;
import mousekids.gui.BoardStyle;
import mousekids.gui.ContinueActionEventHandler;
import mousekids.gui.RatioKeepingLayout;
import mousekids.gui.SimpleComponent;

public class SelectionBoard
extends Board {
    private static final double selectableRatio = 0.33;
    private SelectionTile selectedXPredictor;
    private InquiryUserController inqCtrl;
    private JButton nextButton;
    private JPanel selPanel;
    private int placesTaken;

    public SelectionBoard(InquiryUserController inqCtrl, SessionStateReflector sessionStateReflector, Object nextChosen, BoardStyle boardStyle) {
        super(inqCtrl, sessionStateReflector, nextChosen, boardStyle);
        this.inqCtrl = inqCtrl;
        this.placesTaken = 0;
        int noap = sessionStateReflector.getNumberOfAvailablePredictors();
        int nosp = sessionStateReflector.getNumberOfSelectablePredictors();
        int x = (int)Math.ceil((double)noap * 0.33);
        int y = (int)Math.ceil((double)noap / (double)x);
        int width = 2 * x + 2 + 1 + 1 + 1;
        int height = Math.max(2 * y + 1, 2 * nosp + 1);
        double[] horizontalAlignment = new double[width];
        int i = 0;
        while (i < x) {
            horizontalAlignment[i * 2 + 2] = 0.5;
            horizontalAlignment[i * 2 + 1] = 1.0;
            ++i;
        }
        horizontalAlignment[0] = 1.0;
        horizontalAlignment[width - 1] = 1.0;
        horizontalAlignment[width - 3] = 1.0;
        horizontalAlignment[width - 2] = 1.0;
        double[] verticalAlignment = new double[height];
        int i2 = 0;
        while (i2 < nosp) {
            verticalAlignment[i2 * 2 + 2] = 0.5;
            verticalAlignment[i2 * 2 + 1] = 1.0;
            ++i2;
        }
        verticalAlignment[0] = 1.0;
        verticalAlignment[height - 1] = 1.0;
        this.selPanel = new JPanel(new AlignGridLayout(horizontalAlignment, verticalAlignment));
        int pred = 0;
        int j = 0;
        block2: while (j < y) {
            int i3 = 0;
            while (i3 < x) {
                String predName = sessionStateReflector.getAvailablePredictor(pred);
                String pos = String.valueOf(i3 * 2 + 1) + "x" + (j * 2 + 1);
                SelectionTile st = new SelectionTile(predName, null, boardStyle, "predictor." + predName, pos);
                this.selPanel.add(pos, st);
                if (++pred >= noap) break block2;
                ++i3;
            }
            ++j;
        }
        int i4 = 0;
        while (i4 < nosp) {
            String pos = String.valueOf(width - 1 - 1) + "x" + (i4 * 2 + 1);
            PlaceholderTile pht = new PlaceholderTile(Color.BLUE, boardStyle, pos, i4 + 1);
            this.selPanel.add(pos, pht);
            ++i4;
        }
        this.nextButton = new JButton("continue");
        this.nextButton.addActionListener(new ContinueActionEventHandler(nextChosen));
        this.component = new JPanel(new AlignGridLayout(new double[]{1.0}, new double[]{0.125, 0.8, 0.075}), true);
        this.component.add("0x1", this.selPanel);
        this.component.add("0x2", this.nextButton);
        this.updateNextButton();
    }

    private void updateNextButton() {
        this.nextButton.setVisible(this.sessionStateReflector.isNextable());
    }

    private boolean allPlacesFull() {
        return this.placesTaken >= this.sessionStateReflector.getNumberOfSelectablePredictors();
    }

    private class PlaceholderTile
    extends JPanel {
        private static final long serialVersionUID = 6631677483549398916L;
        private String rightPosition;
        private boolean onLeftSide;
        private int selectionIndex;

        public PlaceholderTile(Color c, BoardStyle boardStyle, String rightPos, int selectionIndex) {
            this.rightPosition = rightPos;
            this.selectionIndex = selectionIndex;
            SimpleComponent sc = new SimpleComponent(c, boardStyle, null);
            this.setLayout(new RatioKeepingLayout(1.0));
            sc.setBorder(BorderFactory.createBevelBorder(0));
            this.add(sc);
            this.addMouseListener(new EventHandler());
        }

        public String getOriginBoardPos() {
            return this.rightPosition;
        }

        public void setOnLeftSide(boolean onLeftSide) {
            this.onLeftSide = onLeftSide;
        }

        private class EventHandler
        extends MouseAdapter {
            private EventHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!PlaceholderTile.this.onLeftSide && SelectionBoard.this.selectedXPredictor != null) {
                    SelectionBoard.this.selPanel.remove(SelectionBoard.this.selectedXPredictor);
                    SelectionBoard.this.selPanel.remove(PlaceholderTile.this);
                    SelectionBoard.this.selectedXPredictor.setPlace(PlaceholderTile.this);
                    SelectionBoard.this.selPanel.add(SelectionBoard.this.selectedXPredictor.getOriginBoardPos(), PlaceholderTile.this);
                    SelectionBoard.this.selPanel.add(PlaceholderTile.this.getOriginBoardPos(), SelectionBoard.this.selectedXPredictor);
                    SelectionBoard.this.selectedXPredictor.setOnRightSide(true);
                    SelectionBoard.this.selectedXPredictor.innerTile.setBorder(BorderFactory.createBevelBorder(0));
                    SelectionBoard.this.selectedXPredictor.repaint();
                    SelectionBoard.this.selectedXPredictor.setSelectedIndex(PlaceholderTile.this.selectionIndex);
                    SelectionBoard.this.inqCtrl.selectPredictor(PlaceholderTile.this.selectionIndex, SelectionBoard.this.selectedXPredictor.getPredictorName());
                    SelectionBoard.this.selectedXPredictor = null;
                    PlaceholderTile.this.onLeftSide = true;
                    SelectionBoard selectionBoard = SelectionBoard.this;
                    selectionBoard.placesTaken = selectionBoard.placesTaken + 1;
                }
                PlaceholderTile.this.repaint();
                PlaceholderTile.this.getParent().doLayout();
                SelectionBoard.this.updateNextButton();
            }
        }
    }

    private class SelectionTile
    extends JLayeredPane {
        private static final long serialVersionUID = -5744207123852641646L;
        private boolean onRightSide;
        private String leftPosition;
        private PlaceholderTile place;
        private SimpleComponent innerTile;
        private int selectedIndex;
        private String predictorName;

        public SelectionTile(String predictorName, Color c, BoardStyle boardStyle, String imgName, String leftPos) {
            this.leftPosition = leftPos;
            this.addMouseListener(new EventHandler());
            this.innerTile = new SimpleComponent(c, boardStyle, imgName);
            this.innerTile.setBorder(BorderFactory.createBevelBorder(0));
            this.setLayout(new RatioKeepingLayout(1.0));
            this.add((Component)this.innerTile, new Integer(1));
            this.add((Component)new JComponent(){
                private static final long serialVersionUID = 5279559572178088568L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.BLUE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (SelectionBoard.this.selectedXPredictor == SelectionTile.this) {
                        Rectangle rect = SelectionTile.this.innerTile.getBounds();
                        g.setColor(Color.BLUE);
                        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    }
                }
            }, new Integer(2));
            this.selectedIndex = -1;
            this.predictorName = predictorName;
        }

        public String getOriginBoardPos() {
            return this.leftPosition;
        }

        public void setOnRightSide(boolean onRightSide) {
            this.onRightSide = onRightSide;
        }

        public void setPlace(PlaceholderTile place) {
            this.place = place;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public String getPredictorName() {
            return this.predictorName;
        }

        private class EventHandler
        extends MouseAdapter {
            private EventHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SelectionTile.this.onRightSide) {
                    SelectionBoard.this.selectedXPredictor = SelectionTile.this;
                    SelectionBoard.this.selPanel.remove(SelectionTile.this);
                    SelectionBoard.this.selPanel.remove(SelectionTile.this.place);
                    SelectionTile.this.place.setOnLeftSide(false);
                    SelectionBoard.this.selPanel.add(SelectionTile.this.place.getOriginBoardPos(), SelectionTile.this.place);
                    SelectionBoard.this.selPanel.add(SelectionBoard.this.selectedXPredictor.getOriginBoardPos(), SelectionBoard.this.selectedXPredictor);
                    SelectionBoard.this.inqCtrl.deselectPredictor(SelectionTile.this.selectedIndex);
                    SelectionTile.this.selectedIndex = -1;
                    SelectionTile.this.onRightSide = false;
                    SelectionBoard.this.selectedXPredictor = null;
                    SelectionTile.this.place = null;
                    SelectionBoard selectionBoard = SelectionBoard.this;
                    selectionBoard.placesTaken = selectionBoard.placesTaken - 1;
                } else if (!SelectionBoard.this.allPlacesFull()) {
                    SelectionTile temp = SelectionBoard.this.selectedXPredictor;
                    SelectionBoard.this.selectedXPredictor = SelectionTile.this;
                    if (SelectionBoard.this.selectedXPredictor != null) {
                        SelectionBoard.this.selectedXPredictor.innerTile.setBorder(BorderFactory.createBevelBorder(1));
                        if (temp != SelectionBoard.this.selectedXPredictor) {
                            temp.innerTile.setBorder(BorderFactory.createBevelBorder(0));
                        }
                    }
                    if (temp != null) {
                        temp.repaint();
                    }
                }
                SelectionTile.this.repaint();
                SelectionTile.this.getParent().doLayout();
                SelectionBoard.this.updateNextButton();
            }
        }
    }
}

